/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.download;

import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.lang.math.LongRange;
import org.lastbamboo.common.download.DefaultRangeSizeSelector;
import org.lastbamboo.common.download.LongRangeComparator;
import org.lastbamboo.common.download.RangeSizeSelector;
import org.lastbamboo.common.download.RangeTracker;
import org.littleshoot.util.NoneImpl;
import org.littleshoot.util.Optional;
import org.littleshoot.util.SomeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeTrackerImpl
implements RangeTracker {
    private final Logger m_log = LoggerFactory.getLogger(RangeTrackerImpl.class);
    private final Set<LongRange> m_active;
    private final Queue<LongRange> m_inactive;
    private final int m_numChunks;
    private volatile long m_bytesRead;
    private final long m_chunkSize;

    public RangeTrackerImpl(long fileSize, int numSources) {
        this(fileSize, numSources, new DefaultRangeSizeSelector());
    }

    public RangeTrackerImpl(long fileSize, int numSources, RangeSizeSelector rangeSizeSelector) {
        this.m_log.debug("Creating queue for file size: " + fileSize);
        this.m_chunkSize = rangeSizeSelector.selectSize(fileSize, numSources);
        this.m_log.debug("Chunk size is: {}", (Object)this.m_chunkSize);
        this.m_numChunks = (int)Math.ceil(fileSize / this.m_chunkSize);
        this.m_log.debug("Creating a queue with " + this.m_numChunks + " chunks...");
        LongRangeComparator rangeComparator = new LongRangeComparator();
        this.m_inactive = new PriorityQueue<LongRange>(this.m_numChunks, rangeComparator);
        this.m_active = new HashSet<LongRange>();
        long index = 0L;
        while (index < fileSize) {
            long max = Math.min(fileSize - 1L, index + this.m_chunkSize - 1L);
            LongRange curRange = new LongRange(index, max);
            this.m_inactive.add(curRange);
            index = max + 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<LongRange> getNextRange() {
        RangeTrackerImpl rangeTrackerImpl = this;
        synchronized (rangeTrackerImpl) {
            while (this.m_inactive.isEmpty() && !this.m_active.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    this.m_log.error("Wait interrupted", (Throwable)e);
                    throw new RuntimeException("Wait interrupted", e);
                }
            }
            if (this.m_inactive.isEmpty()) {
                if (this.m_active.isEmpty()) {
                    return new NoneImpl();
                }
                this.m_log.error("Active ranges???");
                throw new RuntimeException("Illegal program state");
            }
            LongRange nextRange = this.m_inactive.poll();
            this.m_active.add(nextRange);
            return new SomeImpl((Object)nextRange);
        }
    }

    @Override
    public int getNumChunks() {
        return this.m_numChunks;
    }

    @Override
    public boolean hasMoreRanges() {
        return !this.m_inactive.isEmpty() || !this.m_active.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangeComplete(LongRange range) {
        this.m_log.debug("Range complete: {}", (Object)range);
        RangeTrackerImpl rangeTrackerImpl = this;
        synchronized (rangeTrackerImpl) {
            if (this.m_active.contains(range)) {
                this.m_bytesRead += range.getMaximumLong() - range.getMinimumLong();
            } else {
                this.m_log.error("Nothing known about range: " + range + "\nActively downloading: " + this.m_active + "\nWaiting:              " + this.m_inactive);
                throw new RuntimeException("Range '" + range + "' is unknown to this tracker");
            }
            this.m_active.remove(range);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangeFailed(LongRange range) {
        this.m_log.debug("Range failed: {}", (Object)range);
        RangeTrackerImpl rangeTrackerImpl = this;
        synchronized (rangeTrackerImpl) {
            if (!this.m_active.contains(range)) {
                this.m_log.error("Nothing known about range: " + range + "\nActively downloading: " + this.m_active + "\nWaiting:              " + this.m_inactive);
                throw new RuntimeException("Range '" + range + "' is unknown to this tracker");
            }
            this.m_active.remove(range);
            this.m_inactive.add(range);
            this.notifyAll();
        }
    }

    @Override
    public long getBytesRead() {
        return this.m_bytesRead;
    }
}

