/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.download;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.lastbamboo.common.download.RangeDownloader;
import org.lastbamboo.common.download.RateCalculator;
import org.lastbamboo.common.download.RateSegment;
import org.lastbamboo.common.download.RateSegmentImpl;
import org.littleshoot.util.CollectionUtils;
import org.littleshoot.util.CollectionUtilsImpl;
import org.littleshoot.util.F1;
import org.littleshoot.util.NoneImpl;
import org.littleshoot.util.Optional;
import org.littleshoot.util.OptionalUtils;
import org.littleshoot.util.OptionalUtilsImpl;
import org.littleshoot.util.SomeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateCalculatorImpl
implements RateCalculator {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final CollectionUtils m_collectionUtils;
    private final OptionalUtils m_optionalUtils;
    private final Map<Long, RateSegment> m_rateSegments = Collections.synchronizedMap(new LinkedHashMap<Long, RateSegment>(){
        private static final long serialVersionUID = -243416056459048328L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, RateSegment> eldest) {
            boolean remove = this.size() > 100;
            return remove;
        }
    });

    private static long getPartialSize(long partialDuration, long duration, long size) {
        return duration == 0L ? size : (long)((double)partialDuration / (double)duration * (double)size);
    }

    public RateCalculatorImpl() {
        this.m_collectionUtils = new CollectionUtilsImpl();
        this.m_optionalUtils = new OptionalUtilsImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getRate() {
        Collection valid;
        LinkedList<RateSegment> segments;
        if (this.m_log.isDebugEnabled()) {
            // empty if block
        }
        final long since = System.currentTimeMillis() - 5000L;
        F1<RateSegment, Optional<RateSegment>> f = new F1<RateSegment, Optional<RateSegment>>(){

            public Optional<RateSegment> run(RateSegment segment) {
                long end = segment.getStart() + segment.getDuration();
                if (end <= since) {
                    return new NoneImpl();
                }
                if (since <= segment.getStart()) {
                    return new SomeImpl((Object)segment);
                }
                long partialDuration = end - since;
                long partialSize = RateCalculatorImpl.getPartialSize(partialDuration, segment.getDuration(), segment.getSize());
                RateSegmentImpl partial = new RateSegmentImpl(since, partialDuration, partialSize);
                return new SomeImpl((Object)partial);
            }
        };
        Object object = this.m_rateSegments;
        synchronized (object) {
            segments = new LinkedList<RateSegment>(this.m_rateSegments.values());
        }
        object = segments;
        synchronized (object) {
            valid = this.m_optionalUtils.filterNones(this.m_collectionUtils.map(segments, (F1)f));
        }
        F1<RateSegment, Long> getDuration = new F1<RateSegment, Long>(){

            public Long run(RateSegment segment) {
                return segment.getDuration();
            }
        };
        Collection durations = this.m_collectionUtils.map(valid, (F1)getDuration);
        F1<RateSegment, Long> getSize = new F1<RateSegment, Long>(){

            public Long run(RateSegment segment) {
                return segment.getSize();
            }
        };
        Collection sizes = this.m_collectionUtils.map(valid, (F1)getSize);
        long totalDuration = this.m_collectionUtils.sum(durations);
        long totalSize = this.m_collectionUtils.sum(sizes);
        double rate = totalDuration > 0L ? (double)totalSize / (double)totalDuration : 0.0;
        return rate > 2.147483647E9 ? 2.147483647E9 : (double)((int)rate);
    }

    @Override
    public void addData(RangeDownloader downloader) {
        long start = downloader.getRangeStartTime();
        long end = System.currentTimeMillis();
        long size = downloader.getNumBytesDownloaded();
        RateSegmentImpl segment = new RateSegmentImpl(start, end - start, size);
        long rangeIndex = downloader.getRangeIndex();
        this.m_rateSegments.put(new Long(rangeIndex), segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBytesRead() {
        long bytesRead = 0L;
        Map<Long, RateSegment> map = this.m_rateSegments;
        synchronized (map) {
            for (RateSegment segment : this.m_rateSegments.values()) {
                bytesRead += segment.getSize();
            }
        }
        return bytesRead;
    }
}

