/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.download;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.lang.math.LongRange;
import org.lastbamboo.common.download.LaunchFileTracker;
import org.lastbamboo.common.download.RangeDownloadListener;
import org.lastbamboo.common.download.RangeDownloader;
import org.lastbamboo.common.download.RangeTracker;
import org.lastbamboo.common.download.SourceRanker;
import org.lastbamboo.common.http.client.CommonsHttpClient;
import org.lastbamboo.common.http.client.HttpClientRunner;
import org.lastbamboo.common.http.client.HttpListener;
import org.lastbamboo.common.http.client.NoContentRangeException;
import org.lastbamboo.common.http.client.RuntimeHttpException;
import org.littleshoot.util.InputStreamHandler;
import org.littleshoot.util.IoUtils;
import org.littleshoot.util.LongRangeListener;
import org.littleshoot.util.NoneImpl;
import org.littleshoot.util.Optional;
import org.littleshoot.util.RuntimeIoException;
import org.littleshoot.util.SomeImpl;
import org.littleshoot.util.WriteListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleSourceDownloader
implements RangeDownloader,
InputStreamHandler,
HttpListener {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final URI m_uri;
    private final SourceRanker m_sourceRanker;
    private final RandomAccessFile m_randomAccessFile;
    private LongRange m_contentRange;
    private LongRange m_assignedRange;
    private final RangeTracker m_rangeTracker;
    private final RangeDownloadListener m_rangeDownloadListener;
    private long m_startedTime = -1L;
    private long m_contentLength = -1L;
    private long m_completedTime = -1L;
    private long m_numBytesDownloaded;
    private int m_completedRanges = 0;
    private final LaunchFileTracker m_launchFileTracker;
    private final CommonsHttpClient m_httpClient;
    private volatile int m_numFailures = 0;

    public SingleSourceDownloader(CommonsHttpClient httpClient, URI source, RangeDownloadListener rangeDownloadListener, SourceRanker downloadSpeedRanker, RangeTracker rangeTracker, LaunchFileTracker launchTracker, RandomAccessFile randomAccessFile) {
        this.m_uri = source;
        this.m_rangeDownloadListener = rangeDownloadListener;
        this.m_sourceRanker = downloadSpeedRanker;
        this.m_rangeTracker = rangeTracker;
        this.m_launchFileTracker = launchTracker;
        this.m_randomAccessFile = randomAccessFile;
        this.m_httpClient = httpClient;
        if (!this.m_uri.toString().startsWith("http://")) {
            DefaultHttpMethodRetryHandler retryHandler = new DefaultHttpMethodRetryHandler(0, false);
            this.m_httpClient.getParams().setParameter("http.method.retry-handler", (Object)retryHandler);
        }
        this.m_numBytesDownloaded = 0L;
    }

    @Override
    public void download(LongRange range) {
        this.m_completedTime = -1L;
        this.m_startedTime = -1L;
        this.m_contentLength = -1L;
        this.m_assignedRange = range;
        this.m_log.debug("Downloading from: " + this.m_uri);
        GetMethod method = new GetMethod(this.m_uri.toString());
        method.getParams().setBooleanParameter("http.protocol.warn-extra-input", true);
        String rangesSpecifier = "bytes=" + range.getMinimumLong() + "-" + range.getMaximumLong();
        method.addRequestHeader("Range", rangesSpecifier);
        this.m_log.debug("HTTP connection manager: " + this.m_httpClient.getHttpConnectionManager().getClass());
        HttpClientRunner runner = new HttpClientRunner((InputStreamHandler)this, this.m_httpClient, (HttpMethod)method, (HttpListener)this);
        Thread httpThread = new Thread((Runnable)runner, "HTTP-Download-Thread-" + this.hashCode());
        httpThread.setDaemon(true);
        httpThread.start();
    }

    @Override
    public void issueHeadRequest() {
        Runnable headRunner = new Runnable(){

            @Override
            public void run() {
                try {
                    SingleSourceDownloader.this.sendHeadRequest();
                }
                catch (Throwable t) {
                    SingleSourceDownloader.this.m_log.error("Unexpected throwable.", t);
                    SingleSourceDownloader.this.m_rangeDownloadListener.onFail(SingleSourceDownloader.this);
                }
            }
        };
        Thread headThread = new Thread(headRunner, "HTTP-Head-Thread-" + headRunner.hashCode());
        headThread.setDaemon(true);
        headThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendHeadRequest() {
        String uri = this.m_uri.toString();
        this.m_log.debug("Sending request to URI: {}", (Object)uri);
        HeadMethod method = new HeadMethod(uri);
        try {
            this.m_httpClient.executeMethod((HttpMethod)method);
            this.m_log.debug("Finished executing method for HEAD request...");
            int statusCode = method.getStatusCode();
            if (statusCode == 200) {
                method.releaseConnection();
                this.m_rangeDownloadListener.onConnect(this);
            } else if (statusCode == 206) {
                method.releaseConnection();
                Header range = method.getResponseHeader("Content-Range");
                if (range != null) {
                    this.m_rangeDownloadListener.onConnect(this);
                } else {
                    this.m_rangeDownloadListener.onFail(this);
                }
            } else {
                this.m_log.debug("Status code: " + statusCode);
            }
        }
        catch (RuntimeHttpException e) {
            this.m_log.debug("HTTP exception contacting source", (Throwable)e);
            this.m_rangeDownloadListener.onFail(this);
        }
        catch (RuntimeIoException e) {
            this.m_log.debug("IO error contacting source", (Throwable)e);
            this.m_rangeDownloadListener.onFail(this);
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    public Optional<Integer> getKbs() {
        if (this.m_contentLength == -1L || this.m_startedTime == -1L || this.m_completedTime == -1L) {
            this.m_log.debug("Trying to get kbs without enough data.  Content Length: " + this.m_contentLength + " Connect Time: " + this.m_startedTime + " Completed " + "Time: " + this.m_completedTime);
            return new NoneImpl();
        }
        if (this.m_completedTime == this.m_startedTime) {
            this.m_log.warn("Completed time same as connected time: " + this.m_completedTime);
        }
        long safeCompletedTime = Math.max(this.m_completedTime, this.m_startedTime + 1L);
        long downloadMs = safeCompletedTime - this.m_startedTime;
        int kbs = (int)(this.m_contentLength * 1000L / downloadMs * 1024L);
        return new SomeImpl((Object)kbs);
    }

    @Override
    public long getNumBytesDownloaded() {
        return this.m_numBytesDownloaded;
    }

    @Override
    public URI getSourceUri() {
        return this.m_uri;
    }

    public void handleInputStream(InputStream is) throws IOException {
        this.m_log.debug("Handling input stream -- copying to file and stream.");
        this.m_numBytesDownloaded = 0L;
        this.copy(is);
    }

    private void copy(InputStream is) throws IOException {
        if (this.m_contentRange == null) {
            this.m_log.error("No Content-Range header from: {} ...expecting: " + this.m_assignedRange, (Object)this.m_uri);
            throw new NoContentRangeException("No content range");
        }
        long min = this.m_contentRange.getMinimumLong();
        long max = this.m_contentRange.getMaximumLong();
        int expectedBytes = (int)(max - min + 1L);
        WriteListener writeListener = new WriteListener(){

            public void onBytesRead(int bytesRead) {
                SingleSourceDownloader.this.m_numBytesDownloaded += bytesRead;
                SingleSourceDownloader.this.m_rangeDownloadListener.onBytesRead(SingleSourceDownloader.this);
            }
        };
        IoUtils.copy((InputStream)is, (RandomAccessFile)this.m_randomAccessFile, (long)min, (long)expectedBytes, (LongRangeListener)this.m_launchFileTracker, (WriteListener)writeListener);
    }

    public void onContentLength(long contentLength) {
        this.m_log.debug("Received content length: " + contentLength);
        this.m_contentLength = contentLength;
    }

    public void onCouldNotConnect() {
        this.m_log.debug("Received could not connect...");
        this.onFailure();
    }

    public void onConnect(long ms) {
    }

    public void onFailure() {
        this.m_log.debug("Received download failure number: " + this.m_numFailures + " for: " + this);
        this.m_rangeTracker.onRangeFailed(this.m_assignedRange);
        ++this.m_numFailures;
        if (this.m_numFailures < 4) {
            this.m_sourceRanker.onAvailable(this);
        }
    }

    public void onPermanentFailure() {
        this.m_rangeTracker.onRangeFailed(this.m_assignedRange);
    }

    public void onHttpException(HttpException httpException) {
        this.m_log.debug("Received HTTP exception");
        this.onFailure();
    }

    public void onNoTwoHundredOk(int responseCode) {
        this.m_log.debug("No 200-level response...re-submitting range...");
        this.onFailure();
    }

    public void onMessageBodyRead() {
        this.m_log.debug("Read message body!!");
        this.m_completedTime = System.currentTimeMillis();
        this.m_numBytesDownloaded = this.m_contentLength;
        this.m_log.info("Completed time recorded as: " + this.m_completedTime);
        this.m_rangeTracker.onRangeComplete(this.m_assignedRange);
        ++this.m_completedRanges;
        if (this.m_numFailures > 0) {
            --this.m_numFailures;
        }
        this.m_rangeDownloadListener.onDownloadFinished(this);
        this.m_sourceRanker.onAvailable(this);
    }

    public void onBadHeader(String header) {
        this.m_log.warn("Could not understand header: {}", (Object)header);
        this.onFailure();
    }

    public void onContentRange(LongRange range) throws IOException {
        this.m_log.debug("Received Content-Range: " + range);
        if (!range.equals((Object)this.m_assignedRange)) {
            String msg = "Bad range -- expected: " + this.m_assignedRange + " but was: " + range;
            this.m_log.error(msg);
            throw new IOException(msg);
        }
        this.m_contentRange = range;
    }

    public void onStatusEvent(String status) {
    }

    public void onDownloadStarted() {
        this.m_startedTime = System.currentTimeMillis();
        this.m_log.info("Connected time recorded as: " + this.m_startedTime);
        this.m_rangeDownloadListener.onDownloadStarted(this);
    }

    public void onBytesRead(int bytesRead) {
    }

    @Override
    public long getRangeStartTime() {
        return this.m_startedTime;
    }

    @Override
    public long getRangeIndex() {
        return this.m_assignedRange.getMinimumLong();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " with " + this.m_completedRanges + " completed ranges for: " + this.m_uri + "-" + this.hashCode();
    }
}

