/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.download;

import java.net.URI;
import java.util.Comparator;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.commons.lang.math.LongRange;
import org.lastbamboo.common.download.RangeDownloader;
import org.lastbamboo.common.download.SourceRanker;
import org.littleshoot.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceRankerImpl
implements SourceRanker {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final PriorityBlockingQueue<RangeDownloader> m_sources;

    public SourceRankerImpl(Comparator<RangeDownloader> comparator) {
        this.m_sources = new PriorityBlockingQueue<RangeDownloader>(20, comparator);
    }

    @Override
    public boolean hasMoreSources() {
        return !this.m_sources.isEmpty();
    }

    @Override
    public RangeDownloader getBestSource() {
        try {
            return this.m_sources.take();
        }
        catch (InterruptedException e) {
            this.m_log.warn("Interrupt waiting for sources!!", (Throwable)e);
            return null;
        }
    }

    @Override
    public void onAvailable(RangeDownloader downloader) {
        this.m_log.debug("New source available: {}", (Object)downloader);
        this.m_sources.add(downloader);
    }

    @Override
    public void onFailed() {
        this.m_sources.add(new DummyRangeDownloader());
    }

    private static final class DummyRangeDownloader
    implements RangeDownloader {
        private DummyRangeDownloader() {
        }

        @Override
        public void download(LongRange range) {
        }

        @Override
        public Optional<Integer> getKbs() {
            return null;
        }

        @Override
        public long getNumBytesDownloaded() {
            return 0L;
        }

        @Override
        public URI getSourceUri() {
            return null;
        }

        @Override
        public void issueHeadRequest() {
        }

        @Override
        public long getRangeIndex() {
            return 0L;
        }

        @Override
        public long getRangeStartTime() {
            return 0L;
        }
    }
}

