/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import org.lastbamboo.common.ice.IceAgent;
import org.lastbamboo.common.ice.IceStunUdpPeer;
import org.lastbamboo.common.ice.UdpSocketFactory;
import org.lastbamboo.common.offer.answer.OfferAnswerListener;
import org.lastbamboo.common.stun.server.StunServer;
import org.littleshoot.mina.common.IoAcceptor;
import org.littleshoot.mina.common.IoService;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.transport.socket.nio.support.DatagramSessionImpl;
import org.littleshoot.util.FiveTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointFactory
implements UdpSocketFactory<FiveTuple> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void newEndpoint(IoSession session, boolean controlling, OfferAnswerListener<FiveTuple> endpointListener, IceStunUdpPeer stunUdpPeer, IceAgent iceAgent) {
        this.log.debug("Creating new endpoint");
        if (session == null) {
            this.log.error("Null session: {}", (Object)session);
            return;
        }
        if (controlling) {
            long sleepTime = 1200L;
            this.log.debug("Client side sleeping for {} milliseconds", (Object)1200L);
            try {
                Thread.sleep(1200L);
            }
            catch (InterruptedException e) {
                this.log.warn("Sleep interrupted?", (Throwable)e);
            }
        }
        this.clear(session, stunUdpPeer, iceAgent);
        InetSocketAddress local = (InetSocketAddress)session.getLocalAddress();
        InetSocketAddress remote = (InetSocketAddress)session.getRemoteAddress();
        this.log.debug("Session local was: {}", (Object)local);
        FiveTuple tuple = new FiveTuple(local, remote, FiveTuple.Protocol.UDP);
        endpointListener.onUdpSocket((Object)tuple);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(IoSession session, IceStunUdpPeer stunUdpPeer, IceAgent iceAgent) {
        this.log.debug("Closing ICE agent");
        iceAgent.close();
        this.log.debug("Clearing session: {}", (Object)session);
        DatagramSessionImpl dgSession = (DatagramSessionImpl)session;
        DatagramChannel dgChannel = dgSession.getChannel();
        session.close().join(10000L);
        StunServer stunServer = stunUdpPeer.getStunServer();
        stunServer.close();
        try {
            IoService service = session.getService();
            this.log.debug("Service is: {}", (Object)service);
            if (IoAcceptor.class.isAssignableFrom(service.getClass())) {
                this.log.debug("Unbinding all!!");
                IoAcceptor acceptor = (IoAcceptor)service;
                acceptor.unbindAll();
            }
            session.getService().getFilterChain().clear();
            dgChannel.disconnect();
            dgChannel.close();
            this.log.debug("Open: " + dgChannel.isOpen());
            this.log.debug("Connected: " + dgChannel.isConnected());
            this.log.debug("Sleeping on channel to make sure it unbinds");
            Thread.sleep(400L);
            this.log.debug("Closed channel");
        }
        catch (Exception e) {
            this.log.error("Error clearing session!!", (Throwable)e);
        }
        finally {
            stunUdpPeer.close();
        }
    }
}

