/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import org.lastbamboo.common.ice.ExistingSessionIceCandidatePairFactoryImpl;
import org.lastbamboo.common.ice.GeneralIceMediaStreamFactory;
import org.lastbamboo.common.ice.IceAgent;
import org.lastbamboo.common.ice.IceCheckListImpl;
import org.lastbamboo.common.ice.IceCheckSchedulerImpl;
import org.lastbamboo.common.ice.IceMediaStream;
import org.lastbamboo.common.ice.IceMediaStreamImpl;
import org.lastbamboo.common.ice.IceStunCheckerFactoryImpl;
import org.lastbamboo.common.ice.IceStunConnectivityCheckerFactoryImpl;
import org.lastbamboo.common.ice.IceStunUdpPeer;
import org.lastbamboo.common.ice.IceUdpConnectException;
import org.lastbamboo.common.ice.candidate.IceCandidate;
import org.lastbamboo.common.ice.candidate.IceCandidatePairFactoryImpl;
import org.lastbamboo.common.ice.candidate.UdpIceCandidateGatherer;
import org.lastbamboo.common.ice.transport.IceUdpConnector;
import org.lastbamboo.common.offer.answer.IceMediaStreamDesc;
import org.lastbamboo.common.turn.client.TurnClientListener;
import org.littleshoot.mina.common.IoHandler;
import org.littleshoot.mina.filter.codec.ProtocolCodecFactory;
import org.littleshoot.stun.stack.StunIoHandler;
import org.littleshoot.stun.stack.StunProtocolCodecFactory;
import org.littleshoot.stun.stack.message.StunMessage;
import org.littleshoot.stun.stack.transaction.StunTransactionTracker;
import org.littleshoot.stun.stack.transaction.StunTransactionTrackerImpl;
import org.littleshoot.util.CandidateProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralIceMediaStreamFactoryImpl
implements GeneralIceMediaStreamFactory {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final CandidateProvider<InetSocketAddress> m_stunServerCandidateProvider;

    public GeneralIceMediaStreamFactoryImpl(CandidateProvider<InetSocketAddress> stunServerCandidateProvider) {
        this.m_stunServerCandidateProvider = stunServerCandidateProvider;
    }

    @Override
    public <T> IceMediaStream newIceMediaStream(IceMediaStreamDesc streamDesc, IceAgent iceAgent, TurnClientListener delegateTurnClientListener) throws IceUdpConnectException {
        IceStunUdpPeer udpStunPeer;
        StunProtocolCodecFactory codecFactory = new StunProtocolCodecFactory();
        StunTransactionTrackerImpl transactionTracker = new StunTransactionTrackerImpl();
        IceStunCheckerFactoryImpl checkerFactory = new IceStunCheckerFactoryImpl((StunTransactionTracker<StunMessage>)transactionTracker);
        IceStunConnectivityCheckerFactoryImpl messageVisitorFactory = new IceStunConnectivityCheckerFactoryImpl(iceAgent, transactionTracker, checkerFactory);
        StunIoHandler udpIoHandler = new StunIoHandler(messageVisitorFactory);
        if (streamDesc.isUdp()) {
            try {
                udpStunPeer = new IceStunUdpPeer((ProtocolCodecFactory)codecFactory, (IoHandler)udpIoHandler, iceAgent.isControlling(), (StunTransactionTracker<StunMessage>)transactionTracker, this.m_stunServerCandidateProvider);
            }
            catch (IOException e) {
                this.m_log.warn("Error connecting UDP peer", (Throwable)e);
                throw new IceUdpConnectException("Could not create UDP peer", e);
            }
        } else {
            udpStunPeer = null;
        }
        UdpIceCandidateGatherer gatherer = new UdpIceCandidateGatherer(udpStunPeer, iceAgent.isControlling(), streamDesc);
        IceMediaStreamImpl stream = new IceMediaStreamImpl(iceAgent, streamDesc, gatherer, udpStunPeer);
        if (udpStunPeer != null) {
            udpStunPeer.addIoServiceListener(stream);
        }
        this.m_log.debug("Added media stream as listener...connecting...");
        if (udpStunPeer != null) {
            try {
                udpStunPeer.connect();
            }
            catch (IOException e) {
                this.m_log.warn("Error connecting UDP peer", (Throwable)e);
                udpStunPeer.close();
                throw new IceUdpConnectException("Could not create UDP peer", e);
            }
        }
        Collection<IceCandidate> localCandidates = gatherer.gatherCandidates();
        IceUdpConnector udpConnector = new IceUdpConnector((ProtocolCodecFactory)codecFactory, (IoHandler)udpIoHandler, iceAgent.isControlling());
        udpConnector.addIoServiceListener(stream);
        IceCandidatePairFactoryImpl candidatePairFactory = new IceCandidatePairFactoryImpl(checkerFactory, udpConnector);
        IceCheckListImpl checkList = new IceCheckListImpl(candidatePairFactory, localCandidates);
        ExistingSessionIceCandidatePairFactoryImpl existingSessionPairFactory = new ExistingSessionIceCandidatePairFactoryImpl(checkerFactory);
        IceCheckSchedulerImpl scheduler = new IceCheckSchedulerImpl(iceAgent, stream, checkList, existingSessionPairFactory);
        stream.start(checkList, localCandidates, scheduler);
        return stream;
    }
}

