/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.id.uuid.UUID;
import org.lastbamboo.common.ice.IceBindingRequestTracker;
import org.littleshoot.stun.stack.message.BindingRequest;
import org.littleshoot.stun.stack.message.StunMessage;

public class IceBindingRequestTrackerImpl
implements IceBindingRequestTracker {
    private final Collection<UUID> m_transactionIds = Collections.synchronizedSet(new LinkedHashSet());
    private static final int UUIDS_TO_STORE = 200;
    private final Map<UUID, StunMessage> m_requestsToResponses = Collections.synchronizedMap(new LinkedHashMap<UUID, StunMessage>(){
        private static final long serialVersionUID = 48319719L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<UUID, StunMessage> eldest) {
            boolean remove = this.size() > 200;
            return remove;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(BindingRequest request) {
        Collection<UUID> collection = this.m_transactionIds;
        synchronized (collection) {
            if (this.m_transactionIds.size() >= 200) {
                UUID lastIn = this.m_transactionIds.iterator().next();
                this.m_transactionIds.remove(lastIn);
            }
            this.m_transactionIds.add(request.getTransactionId());
        }
    }

    @Override
    public boolean recentlyProcessed(BindingRequest request) {
        return this.m_transactionIds.contains(request.getTransactionId());
    }

    @Override
    public void addResponse(BindingRequest request, StunMessage response) {
        this.m_requestsToResponses.put(request.getTransactionId(), response);
    }

    @Override
    public StunMessage getResponse(BindingRequest request) {
        return this.m_requestsToResponses.get(request.getTransactionId());
    }
}

