/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.lastbamboo.common.ice.IceCheckList;
import org.lastbamboo.common.ice.IceCheckListState;
import org.lastbamboo.common.ice.IceTransportProtocol;
import org.lastbamboo.common.ice.candidate.IceCandidate;
import org.lastbamboo.common.ice.candidate.IceCandidatePair;
import org.lastbamboo.common.ice.candidate.IceCandidatePairFactory;
import org.lastbamboo.common.ice.candidate.IceCandidatePairPriorityCalculator;
import org.lastbamboo.common.ice.candidate.IceCandidatePairState;
import org.lastbamboo.common.ice.candidate.IceCandidateVisitor;
import org.lastbamboo.common.ice.candidate.IceTcpActiveCandidate;
import org.lastbamboo.common.ice.candidate.IceTcpHostPassiveCandidate;
import org.lastbamboo.common.ice.candidate.IceTcpPeerReflexiveCandidate;
import org.lastbamboo.common.ice.candidate.IceTcpRelayPassiveCandidate;
import org.lastbamboo.common.ice.candidate.IceTcpServerReflexiveSoCandidate;
import org.lastbamboo.common.ice.candidate.IceUdpHostCandidate;
import org.lastbamboo.common.ice.candidate.IceUdpPeerReflexiveCandidate;
import org.lastbamboo.common.ice.candidate.IceUdpRelayCandidate;
import org.lastbamboo.common.ice.candidate.IceUdpServerReflexiveCandidate;
import org.lastbamboo.common.offer.answer.IceConfig;
import org.littleshoot.util.Closure;
import org.littleshoot.util.CollectionUtilsImpl;
import org.littleshoot.util.Pair;
import org.littleshoot.util.PairImpl;
import org.littleshoot.util.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IceCheckListImpl
implements IceCheckList {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final Queue<IceCandidatePair> m_triggeredQueue = new ConcurrentLinkedQueue<IceCandidatePair>();
    private final List<IceCandidatePair> m_pairs = new ArrayList<IceCandidatePair>();
    private volatile IceCheckListState m_state = IceCheckListState.RUNNING;
    private final Collection<IceCandidate> m_localCandidates;
    private final IceCandidatePairFactory m_iceCandidatePairFactory;
    private final Collection<IceCandidatePair> allPairs = new HashSet<IceCandidatePair>();

    public IceCheckListImpl(IceCandidatePairFactory candidatePairFactory, Collection<IceCandidate> localCandidates) {
        this.m_iceCandidatePairFactory = candidatePairFactory;
        this.m_localCandidates = localCandidates;
        this.m_log.debug("Using local candidates: {}", localCandidates);
    }

    @Override
    public IceCandidatePair removeTopTriggeredPair() {
        while (!this.m_triggeredQueue.isEmpty()) {
            IceCandidatePair pair = this.m_triggeredQueue.poll();
            if (pair.isNominated()) continue;
            return pair;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setState(IceCheckListState state) {
        if (this.m_state != IceCheckListState.COMPLETED) {
            this.m_state = state;
            IceCheckListImpl iceCheckListImpl = this;
            synchronized (iceCheckListImpl) {
                this.m_log.debug("State changed to: {}", (Object)state);
                this.notifyAll();
            }
        }
    }

    @Override
    public IceCheckListState getState() {
        return this.m_state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check() {
        IceCheckListImpl iceCheckListImpl = this;
        synchronized (iceCheckListImpl) {
            while (this.m_state == IceCheckListState.RUNNING) {
                try {
                    this.wait(60000L);
                }
                catch (InterruptedException e) {
                    this.m_log.error("Interrupted??", (Throwable)e);
                }
            }
        }
        this.m_log.debug("Returning from check");
    }

    @Override
    public boolean isActive() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTriggeredPair(IceCandidatePair pair) {
        IceCheckListImpl iceCheckListImpl = this;
        synchronized (iceCheckListImpl) {
            if (!this.m_triggeredQueue.contains(pair)) {
                this.m_log.debug("Adding triggered pair:{}", (Object)pair);
                this.m_triggeredQueue.add(pair);
                this.allPairs.add(pair);
            } else {
                this.m_log.debug("Triggered queue already has pair:{}", (Object)pair);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPair(IceCandidatePair pair) {
        if (pair == null) {
            this.m_log.error("Null pair");
            throw new NullPointerException("Null pair");
        }
        IceCheckListImpl iceCheckListImpl = this;
        synchronized (iceCheckListImpl) {
            this.m_pairs.add(pair);
            this.allPairs.add(pair);
            Collections.sort(this.m_pairs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recomputePairPriorities(boolean controlling) {
        IceCheckListImpl iceCheckListImpl = this;
        synchronized (iceCheckListImpl) {
            this.recompute(this.m_triggeredQueue, controlling);
            this.recompute(this.m_pairs, controlling);
            this.sortPairs(this.m_pairs);
        }
    }

    private void recompute(Collection<IceCandidatePair> pairs, final boolean controlling) {
        Closure<IceCandidatePair> closure = new Closure<IceCandidatePair>(){

            public void execute(IceCandidatePair pair) {
                IceCandidate local = pair.getLocalCandidate();
                IceCandidate remote = pair.getRemoteCandidate();
                local.setControlling(controlling);
                remote.setControlling(!controlling);
                pair.recomputePriority();
            }
        };
        this.executeOnPairs(pairs, closure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void formCheckList(Collection<IceCandidate> remoteCandidates) {
        ArrayList<Pair<IceCandidate, IceCandidate>> pairs = new ArrayList<Pair<IceCandidate, IceCandidate>>(10);
        for (IceCandidate localCandidate : this.m_localCandidates) {
            for (IceCandidate remoteCandidate : remoteCandidates) {
                InetSocketAddress isa = remoteCandidate.getSocketAddress();
                InetAddress remote = isa.getAddress();
                if (remote.isSiteLocalAddress() && IceConfig.isDisableUdpOnLocalNetwork()) {
                    this.m_log.info("Ignoring site local address: {}", (Object)remote);
                    continue;
                }
                if (!IceCheckListImpl.shouldPair(localCandidate, remoteCandidate)) continue;
                PairImpl pair = new PairImpl((Object)localCandidate, (Object)remoteCandidate);
                pairs.add((Pair<IceCandidate, IceCandidate>)pair);
            }
        }
        this.m_log.debug("Pairs before conversion: {}", (Object)pairs.size());
        List<Pair<IceCandidate, IceCandidate>> convertedPairs = IceCheckListImpl.convertPairs(pairs);
        this.m_log.debug("Pairs after conversion:  {}", (Object)convertedPairs.size());
        Comparator<Pair<IceCandidate, IceCandidate>> comparator = new Comparator<Pair<IceCandidate, IceCandidate>>(){

            @Override
            public int compare(Pair<IceCandidate, IceCandidate> pair1, Pair<IceCandidate, IceCandidate> pair2) {
                long pair2Priority;
                long pair1Priority = this.calculatePriority(pair1);
                if (pair1Priority > (pair2Priority = this.calculatePriority(pair2))) {
                    return -1;
                }
                if (pair1Priority < pair2Priority) {
                    return 1;
                }
                return 0;
            }

            private long calculatePriority(Pair<IceCandidate, IceCandidate> pair) {
                return IceCandidatePairPriorityCalculator.calculatePriority((IceCandidate)pair.getFirst(), (IceCandidate)pair.getSecond());
            }
        };
        Collections.sort(convertedPairs, comparator);
        this.m_log.debug(convertedPairs.size() + " converted");
        List<IceCandidatePair> pruned = this.prunePairs(convertedPairs);
        this.m_log.debug(pruned.size() + " after pruned");
        List<IceCandidatePair> sorted = this.sortPairs(pruned);
        IceCheckListImpl iceCheckListImpl = this;
        synchronized (iceCheckListImpl) {
            this.m_pairs.addAll(sorted);
            this.allPairs.addAll(sorted);
            this.m_log.debug("Created pairs:\n" + this.m_pairs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IceCandidatePair> sortPairs(List<IceCandidatePair> pairs) {
        IceCheckListImpl iceCheckListImpl = this;
        synchronized (iceCheckListImpl) {
            Collections.sort(pairs);
        }
        return pairs;
    }

    private static List<Pair<IceCandidate, IceCandidate>> convertPairs(Collection<Pair<IceCandidate, IceCandidate>> pairs) {
        ArrayList<Pair<IceCandidate, IceCandidate>> convertedPairs = new ArrayList<Pair<IceCandidate, IceCandidate>>(pairs.size());
        for (Pair<IceCandidate, IceCandidate> pair : pairs) {
            Pair<IceCandidate, IceCandidate> converted = IceCheckListImpl.convertPair(pair);
            if (converted == null) continue;
            convertedPairs.add(converted);
        }
        return convertedPairs;
    }

    private static Pair<IceCandidate, IceCandidate> convertPair(final Pair<IceCandidate, IceCandidate> pair) {
        IceCandidate localCandidate = (IceCandidate)pair.getFirst();
        final IceCandidate remoteCandidate = (IceCandidate)pair.getSecond();
        IceCandidateVisitor<Pair<IceCandidate, IceCandidate>> visitor = new IceCandidateVisitor<Pair<IceCandidate, IceCandidate>>(){

            @Override
            public void visitCandidates(Collection<IceCandidate> candidates) {
            }

            @Override
            public Pair<IceCandidate, IceCandidate> visitUdpServerReflexiveCandidate(IceUdpServerReflexiveCandidate candidate) {
                InetAddress remoteAddress;
                IceCandidate base = candidate.getBaseCandidate();
                InetAddress localAddress = base.getSocketAddress().getAddress();
                if (localAddress.equals(remoteAddress = remoteCandidate.getSocketAddress().getAddress())) {
                    return null;
                }
                return new PairImpl((Object)base, (Object)remoteCandidate);
            }

            @Override
            public Pair<IceCandidate, IceCandidate> visitTcpActiveCandidate(IceTcpActiveCandidate candidate) {
                return pair;
            }

            @Override
            public Pair<IceCandidate, IceCandidate> visitTcpHostPassiveCandidate(IceTcpHostPassiveCandidate candidate) {
                return null;
            }

            @Override
            public Pair<IceCandidate, IceCandidate> visitTcpRelayPassiveCandidate(IceTcpRelayPassiveCandidate candidate) {
                return null;
            }

            @Override
            public Pair<IceCandidate, IceCandidate> visitTcpServerReflexiveSoCandidate(IceTcpServerReflexiveSoCandidate candidate) {
                return null;
            }

            @Override
            public Pair<IceCandidate, IceCandidate> visitTcpPeerReflexiveCandidate(IceTcpPeerReflexiveCandidate candidate) {
                return null;
            }

            @Override
            public Pair<IceCandidate, IceCandidate> visitUdpHostCandidate(IceUdpHostCandidate candidate) {
                return pair;
            }

            @Override
            public Pair<IceCandidate, IceCandidate> visitUdpPeerReflexiveCandidate(IceUdpPeerReflexiveCandidate candidate) {
                return pair;
            }

            @Override
            public Pair<IceCandidate, IceCandidate> visitUdpRelayCandidate(IceUdpRelayCandidate candidate) {
                return pair;
            }
        };
        return localCandidate.accept(visitor);
    }

    private List<IceCandidatePair> prunePairs(List<Pair<IceCandidate, IceCandidate>> pairs) {
        ArrayList<IceCandidatePair> prunedPairs = new ArrayList<IceCandidatePair>(6);
        HashSet<Pair<IceCandidate, IceCandidate>> seenPairs = new HashSet<Pair<IceCandidate, IceCandidate>>();
        for (Pair<IceCandidate, IceCandidate> pair : pairs) {
            if (seenPairs.contains(pair)) continue;
            seenPairs.add(pair);
            prunedPairs.add(this.createPair(pair));
        }
        if (prunedPairs.size() > 100) {
            return prunedPairs.subList(0, 40);
        }
        return prunedPairs;
    }

    private IceCandidatePair createPair(Pair<IceCandidate, IceCandidate> pair) {
        IceCandidate localCandidate = (IceCandidate)pair.getFirst();
        IceCandidate remoteCandidate = (IceCandidate)pair.getSecond();
        return this.m_iceCandidatePairFactory.newPair(localCandidate, remoteCandidate);
    }

    private static boolean shouldPair(IceCandidate localCandidate, IceCandidate remoteCandidate) {
        if (localCandidate.getSocketAddress().getAddress().equals(remoteCandidate.getSocketAddress().getAddress())) {
            return false;
        }
        return localCandidate.getComponentId() == remoteCandidate.getComponentId() && IceCheckListImpl.addressTypesMatch(localCandidate, remoteCandidate) && IceCheckListImpl.transportTypesMatch(localCandidate, remoteCandidate);
    }

    private static boolean addressTypesMatch(IceCandidate localCandidate, IceCandidate remoteCandidate) {
        InetAddress localAddress = localCandidate.getSocketAddress().getAddress();
        InetAddress remoteAddress = remoteCandidate.getSocketAddress().getAddress();
        boolean localIsIpV4 = localAddress instanceof Inet4Address;
        boolean remoteIsIpV4 = remoteAddress instanceof Inet4Address;
        if (localIsIpV4) {
            return remoteIsIpV4;
        }
        return !remoteIsIpV4;
    }

    private static boolean transportTypesMatch(IceCandidate localCandidate, IceCandidate remoteCandidate) {
        IceTransportProtocol localTransport = localCandidate.getTransport();
        IceTransportProtocol remoteTransport = remoteCandidate.getTransport();
        switch (localTransport) {
            case UDP: {
                return remoteTransport == IceTransportProtocol.UDP;
            }
            case TCP_SO: {
                return remoteTransport == IceTransportProtocol.TCP_SO;
            }
            case TCP_ACT: {
                return remoteTransport == IceTransportProtocol.TCP_PASS;
            }
            case TCP_PASS: {
                return remoteTransport == IceTransportProtocol.TCP_ACT;
            }
        }
        return false;
    }

    @Override
    public boolean hasHigherPriorityPendingPair(IceCandidatePair pair) {
        final long priority = pair.getPriority();
        Predicate<IceCandidatePair> triggeredPred = new Predicate<IceCandidatePair>(){

            public boolean evaluate(IceCandidatePair curPair) {
                return curPair.getPriority() > priority;
            }
        };
        if (this.matchesAny(this.m_triggeredQueue, triggeredPred)) {
            return true;
        }
        Predicate<IceCandidatePair> pred = new Predicate<IceCandidatePair>(){

            public boolean evaluate(IceCandidatePair curPair) {
                if (curPair.getPriority() > priority) {
                    IceCandidatePairState state = curPair.getState();
                    switch (state) {
                        case FROZEN: 
                        case WAITING: 
                        case IN_PROGRESS: {
                            return true;
                        }
                        case SUCCEEDED: 
                        case FAILED: {
                            return false;
                        }
                    }
                }
                return false;
            }
        };
        return this.matchesAny(pred);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWaitingAndFrozenPairs(final IceCandidatePair nominatedPair) {
        this.m_log.debug("Removing waiting and frozen pairs...");
        Predicate<IceCandidatePair> pred = new Predicate<IceCandidatePair>(){

            public boolean evaluate(IceCandidatePair curPair) {
                IceCandidatePairState state = curPair.getState();
                switch (state) {
                    case FROZEN: 
                    case WAITING: {
                        IceCheckListImpl.this.m_log.debug("Closing pair:\n{}", (Object)curPair);
                        curPair.close();
                        return true;
                    }
                    case IN_PROGRESS: {
                        if (curPair.getPriority() < nominatedPair.getPriority()) {
                            IceCheckListImpl.this.m_log.debug("Canceling IN-PROGRESS pair {}", (Object)curPair);
                            curPair.cancelStunTransaction();
                            break;
                        }
                        IceCheckListImpl.this.m_log.debug("Not canceling higher priority IN-PROGRESS pair: {}", (Object)curPair);
                        break;
                    }
                }
                return false;
            }
        };
        IceCheckListImpl iceCheckListImpl = this;
        synchronized (iceCheckListImpl) {
            IceCandidatePair curPair;
            Iterator<IceCandidatePair> iter = this.m_pairs.iterator();
            while (iter.hasNext()) {
                curPair = iter.next();
                if (!pred.evaluate((Object)curPair)) continue;
                iter.remove();
            }
            iter = this.m_triggeredQueue.iterator();
            while (iter.hasNext()) {
                curPair = iter.next();
                if (!pred.evaluate((Object)curPair)) continue;
                iter.remove();
            }
        }
    }

    @Override
    public void executeOnPairs(Closure<IceCandidatePair> closure) {
        this.executeOnPairs(this.m_pairs, closure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IceCandidatePair selectPair(Predicate<IceCandidatePair> pred) {
        IceCheckListImpl iceCheckListImpl = this;
        synchronized (iceCheckListImpl) {
            CollectionUtilsImpl utils = new CollectionUtilsImpl();
            return (IceCandidatePair)utils.selectFirst(this.m_pairs, pred);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IceCandidatePair selectAnyPair(Predicate<IceCandidatePair> pred) {
        IceCheckListImpl iceCheckListImpl = this;
        synchronized (iceCheckListImpl) {
            CollectionUtilsImpl utils = new CollectionUtilsImpl();
            IceCandidatePair pair = (IceCandidatePair)utils.selectFirst(this.m_pairs, pred);
            if (pair != null) {
                return pair;
            }
            return (IceCandidatePair)utils.selectFirst(this.m_triggeredQueue, pred);
        }
    }

    @Override
    public boolean matchesAny(Predicate<IceCandidatePair> pred) {
        return this.matchesAny(this.m_pairs, pred);
    }

    @Override
    public boolean matchesAll(Predicate<IceCandidatePair> pred) {
        return this.matchesAll(this.m_pairs, pred);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchesAny(Collection<IceCandidatePair> pairs, Predicate<IceCandidatePair> pred) {
        IceCheckListImpl iceCheckListImpl = this;
        synchronized (iceCheckListImpl) {
            CollectionUtilsImpl utils = new CollectionUtilsImpl();
            return utils.matchesAny(pairs, pred);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchesAll(Collection<IceCandidatePair> pairs, Predicate<IceCandidatePair> pred) {
        IceCheckListImpl iceCheckListImpl = this;
        synchronized (iceCheckListImpl) {
            CollectionUtilsImpl utils = new CollectionUtilsImpl();
            return utils.matchesAll(pairs, pred);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeOnPairs(Collection<IceCandidatePair> pairs, Closure<IceCandidatePair> closure) {
        IceCheckListImpl iceCheckListImpl = this;
        synchronized (iceCheckListImpl) {
            CollectionUtilsImpl utils = new CollectionUtilsImpl();
            utils.forAllDo(pairs, closure);
        }
    }

    @Override
    public void close() {
        this.m_log.info("Closing check list...");
        Closure<IceCandidatePair> close = new Closure<IceCandidatePair>(){

            public void execute(IceCandidatePair pair) {
                pair.close();
            }
        };
        this.executeOnPairs(close);
        this.executeOnPairs(this.m_triggeredQueue, close);
        this.executeOnPairs(this.allPairs, close);
    }
}

