/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import java.math.BigInteger;
import java.util.Map;
import org.apache.commons.id.uuid.UUID;
import org.lastbamboo.common.ice.IceAgent;
import org.lastbamboo.common.ice.IceRoleChecker;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.stun.stack.message.BindingErrorResponse;
import org.littleshoot.stun.stack.message.BindingRequest;
import org.littleshoot.stun.stack.message.attributes.StunAttributeType;
import org.littleshoot.stun.stack.message.attributes.ice.IceControlledAttribute;
import org.littleshoot.stun.stack.message.attributes.ice.IceControllingAttribute;
import org.littleshoot.util.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IceRoleCheckerImpl
implements IceRoleChecker {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());

    @Override
    public BindingErrorResponse checkAndRepairRoles(BindingRequest request, IceAgent agent, IoSession ioSession) {
        this.m_log.debug("Checking roles...");
        Map remoteAttributes = request.getAttributes();
        if (!remoteAttributes.containsKey(StunAttributeType.ICE_CONTROLLED) && !remoteAttributes.containsKey(StunAttributeType.ICE_CONTROLLING)) {
            this.m_log.warn("No control information.  Old ICE implementation?");
            return null;
        }
        if (agent.isControlling() && remoteAttributes.containsKey(StunAttributeType.ICE_CONTROLLING)) {
            this.m_log.warn("We both think we're controlling...");
            IceControllingAttribute attribute = (IceControllingAttribute)remoteAttributes.get(StunAttributeType.ICE_CONTROLLING);
            if (this.weWin(agent, new BigInteger(attribute.getTieBreaker()))) {
                return this.createErrorResponse(request);
            }
            agent.setControlling(false);
            agent.recomputePairPriorities();
        } else if (!agent.isControlling() && remoteAttributes.containsKey(StunAttributeType.ICE_CONTROLLED)) {
            this.m_log.warn("We both think we're controlled...");
            this.m_log.debug("Transaction ID: {}", (Object)request.getTransactionId());
            IceControlledAttribute attribute = (IceControlledAttribute)remoteAttributes.get(StunAttributeType.ICE_CONTROLLED);
            if (this.weWin(agent, new BigInteger(attribute.getTieBreaker()))) {
                agent.setControlling(true);
                agent.recomputePairPriorities();
            } else {
                return this.createErrorResponse(request);
            }
        }
        return null;
    }

    private BindingErrorResponse createErrorResponse(BindingRequest request) {
        UUID transactionId = request.getTransactionId();
        BindingErrorResponse errorResponse = new BindingErrorResponse(transactionId, 487, "Role Conflict");
        return errorResponse;
    }

    private boolean weWin(IceAgent agent, BigInteger remoteTieBreaker) {
        BigInteger localTieBreaker = new BigInteger(agent.getTieBreaker().toByteArray());
        return NumberUtils.isBiggerOrEqual((BigInteger)localTieBreaker, (BigInteger)remoteTieBreaker);
    }
}

