/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.lastbamboo.common.ice.ExistingSessionIceCandidatePairFactory;
import org.lastbamboo.common.ice.IceAgent;
import org.lastbamboo.common.ice.IceMediaStream;
import org.lastbamboo.common.ice.IcePriorityCalculator;
import org.lastbamboo.common.ice.IceTieBreaker;
import org.lastbamboo.common.ice.IceTransportProtocol;
import org.lastbamboo.common.ice.candidate.IceCandidate;
import org.lastbamboo.common.ice.candidate.IceCandidatePair;
import org.lastbamboo.common.ice.candidate.IceCandidatePairState;
import org.lastbamboo.common.ice.candidate.IceCandidateType;
import org.lastbamboo.common.ice.candidate.IceCandidateVisitorAdapter;
import org.lastbamboo.common.ice.candidate.IceTcpHostPassiveCandidate;
import org.lastbamboo.common.ice.candidate.IceTcpPeerReflexiveCandidate;
import org.lastbamboo.common.ice.candidate.IceTcpRelayPassiveCandidate;
import org.lastbamboo.common.ice.candidate.IceTcpServerReflexiveSoCandidate;
import org.lastbamboo.common.ice.candidate.IceUdpHostCandidate;
import org.lastbamboo.common.ice.candidate.IceUdpPeerReflexiveCandidate;
import org.lastbamboo.common.ice.candidate.IceUdpRelayCandidate;
import org.lastbamboo.common.ice.candidate.IceUdpServerReflexiveCandidate;
import org.littleshoot.stun.stack.message.BindingErrorResponse;
import org.littleshoot.stun.stack.message.BindingRequest;
import org.littleshoot.stun.stack.message.BindingSuccessResponse;
import org.littleshoot.stun.stack.message.CanceledStunMessage;
import org.littleshoot.stun.stack.message.ConnectErrorStunMessage;
import org.littleshoot.stun.stack.message.NullStunMessage;
import org.littleshoot.stun.stack.message.StunMessage;
import org.littleshoot.stun.stack.message.StunMessageVisitor;
import org.littleshoot.stun.stack.message.StunMessageVisitorAdapter;
import org.littleshoot.stun.stack.message.attributes.StunAttribute;
import org.littleshoot.stun.stack.message.attributes.ice.IceControlledAttribute;
import org.littleshoot.stun.stack.message.attributes.ice.IceControllingAttribute;
import org.littleshoot.stun.stack.message.attributes.ice.IcePriorityAttribute;
import org.littleshoot.stun.stack.message.attributes.ice.IceUseCandidateAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IceStunClientCandidateProcessor {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final IceCandidatePair m_pair;
    private final IceAgent m_iceAgent;
    private final IceMediaStream m_mediaStream;
    private final ExistingSessionIceCandidatePairFactory m_existingSessionPairFactory;

    public IceStunClientCandidateProcessor(IceAgent iceAgent, IceMediaStream iceMediaStream, IceCandidatePair udpPair, ExistingSessionIceCandidatePairFactory existingSessionPairFactory) {
        this.m_iceAgent = iceAgent;
        this.m_mediaStream = iceMediaStream;
        this.m_pair = udpPair;
        this.m_existingSessionPairFactory = existingSessionPairFactory;
    }

    public void processLocalCandidate(final IceCandidate localCandidate) {
        boolean includedUseCandidate;
        BindingRequest request;
        IceCandidate remoteCandidate = this.m_pair.getRemoteCandidate();
        final long requestPriority = IcePriorityCalculator.calculatePriority(IceCandidateType.PEER_REFLEXIVE, IceTransportProtocol.UDP);
        IcePriorityAttribute priorityAttribute = new IcePriorityAttribute(requestPriority);
        IceTieBreaker tieBreaker = this.m_iceAgent.getTieBreaker();
        final boolean isControlling = this.m_iceAgent.isControlling();
        Object controlling = isControlling ? new IceControllingAttribute(tieBreaker.toByteArray()) : new IceControlledAttribute(tieBreaker.toByteArray());
        if (this.m_pair.useCandidateSet() && isControlling) {
            this.m_log.info("Creating Binding Request with USE CANDIDATE");
            request = new BindingRequest(new StunAttribute[]{priorityAttribute, controlling, new IceUseCandidateAttribute()});
            includedUseCandidate = true;
        } else {
            request = new BindingRequest(new StunAttribute[]{priorityAttribute, controlling});
            includedUseCandidate = false;
        }
        long rto = 40L;
        this.m_log.debug("Writing Binding Request: {}", (Object)request);
        StunMessage response = this.m_pair.check(request, 40L);
        StunMessageVisitorAdapter<IceCandidate> visitor = new StunMessageVisitorAdapter<IceCandidate>(){

            public IceCandidate visitBindingSuccessResponse(BindingSuccessResponse bsr) {
                IceStunClientCandidateProcessor.this.m_log.info("Visiting binding success response...");
                if (IceStunClientCandidateProcessor.this.m_pair.isNominateOnSuccess()) {
                    IceStunClientCandidateProcessor.this.m_pair.nominate();
                    IceStunClientCandidateProcessor.this.m_iceAgent.onNominatedPair(IceStunClientCandidateProcessor.this.m_pair, IceStunClientCandidateProcessor.this.m_mediaStream);
                    return null;
                }
                InetSocketAddress mappedAddress = bsr.getMappedAddress();
                IceCandidate matchingCandidate = IceStunClientCandidateProcessor.this.m_mediaStream.getLocalCandidate(mappedAddress, localCandidate.isUdp());
                if (matchingCandidate != null) {
                    return matchingCandidate;
                }
                IceUdpPeerReflexiveCandidate peerReflexiveLocal = new IceUdpPeerReflexiveCandidate(mappedAddress, localCandidate, IceStunClientCandidateProcessor.this.m_iceAgent.isControlling(), requestPriority);
                IceStunClientCandidateProcessor.this.m_mediaStream.addLocalCandidate(peerReflexiveLocal);
                return peerReflexiveLocal;
            }

            public IceCandidate visitBindingErrorResponse(BindingErrorResponse bindingErrorResponse) {
                int errorCode = bindingErrorResponse.getErrorCode();
                if (errorCode != 487) {
                    IceStunClientCandidateProcessor.this.m_log.warn("Unexpected error response: " + bindingErrorResponse.getAttributes());
                    IceStunClientCandidateProcessor.this.m_pair.setState(IceCandidatePairState.FAILED);
                    return null;
                }
                if (!isControlling) {
                    IceStunClientCandidateProcessor.this.m_iceAgent.setControlling(true);
                } else {
                    IceStunClientCandidateProcessor.this.m_iceAgent.setControlling(false);
                }
                IceStunClientCandidateProcessor.this.m_pair.setState(IceCandidatePairState.WAITING);
                IceStunClientCandidateProcessor.this.m_mediaStream.addTriggeredPair(IceStunClientCandidateProcessor.this.m_pair);
                return null;
            }

            public IceCandidate visitNullMessage(NullStunMessage message) {
                IceStunClientCandidateProcessor.this.m_log.debug("Visiting null message...");
                IceStunClientCandidateProcessor.this.m_pair.setState(IceCandidatePairState.FAILED);
                return null;
            }

            public IceCandidate visitCanceledMessage(CanceledStunMessage message) {
                IceStunClientCandidateProcessor.this.m_log.debug("Transaction was canceled...");
                return null;
            }

            public IceCandidate visitConnectErrorMesssage(ConnectErrorStunMessage message) {
                IceStunClientCandidateProcessor.this.m_log.debug("Got connect error -- setting pair state to failed.");
                IceStunClientCandidateProcessor.this.m_pair.setState(IceCandidatePairState.FAILED);
                return null;
            }
        };
        if (response == null) {
            this.m_log.debug("No response -- could not connect?");
            this.m_mediaStream.updateCheckListAndTimerStates();
            return;
        }
        IceCandidate newLocalCandidate = (IceCandidate)response.accept((StunMessageVisitor)visitor);
        if (newLocalCandidate == null) {
            this.m_log.debug("Check failed or was canceled -- should happen quite often");
            this.m_mediaStream.updateCheckListAndTimerStates();
            return;
        }
        this.processSuccess(newLocalCandidate, remoteCandidate, includedUseCandidate, requestPriority);
    }

    private void processSuccess(IceCandidate localCandidate, IceCandidate remoteCandidate, boolean useCandidate, long bindingRequestPriority) {
        IceCandidatePair pairToAddToValidList;
        this.m_log.debug("Processing success...");
        if (this.m_iceAgent.isClosed()) {
            this.m_log.info("Agent already closed...ignoring success.");
            return;
        }
        InetSocketAddress remoteAddress = remoteCandidate.getSocketAddress();
        InetSocketAddress newLocalAddress = localCandidate.getSocketAddress();
        if (this.equalsOriginalPair(this.m_pair, newLocalAddress, remoteAddress)) {
            this.m_log.debug("Using original pair...");
            pairToAddToValidList = this.m_pair;
        } else {
            this.m_log.debug("Original pair not equal");
            this.m_log.debug("Original pair was: {}", (Object)this.m_pair);
            this.m_log.debug("New pair addresses: {}" + newLocalAddress, (Object)remoteAddress);
            IceCandidatePair existingPair = this.m_mediaStream.getPair(newLocalAddress, remoteAddress, localCandidate.isUdp());
            if (existingPair != null) {
                this.m_log.debug("Using existing pair...");
                pairToAddToValidList = existingPair;
            } else {
                long remotePriority = this.m_mediaStream.hasRemoteCandidateInSdp(remoteAddress, remoteCandidate.isUdp()) ? this.m_mediaStream.getRemoteCandidate(remoteAddress, remoteCandidate.isUdp()).getPriority() : bindingRequestPriority;
                IceCandidate newRemoteCandidate = IceStunClientCandidateProcessor.createRemoteCandidate(remoteCandidate, remotePriority);
                this.m_log.debug("Creating new pair...");
                pairToAddToValidList = this.m_existingSessionPairFactory.newUdpPair(localCandidate, newRemoteCandidate, this.m_pair.getIoSession());
                this.m_log.debug("Created pair:\n{}", (Object)pairToAddToValidList);
            }
        }
        this.m_log.debug("Adding valid pair...");
        this.m_mediaStream.addValidPair(pairToAddToValidList);
        this.m_log.debug("Updating pair states...");
        this.m_mediaStream.updatePairStates(this.m_pair);
        this.m_iceAgent.checkValidPairsForAllComponents(this.m_mediaStream);
        if (!this.updateNominatedFlag(pairToAddToValidList, useCandidate)) {
            this.m_log.debug("Not Nominated.  Notifying agent of valid pairs...");
            this.m_iceAgent.onValidPairs(this.m_mediaStream);
        }
        this.m_log.debug("Updating check list and timer states.");
        this.m_mediaStream.updateCheckListAndTimerStates();
    }

    private boolean updateNominatedFlag(IceCandidatePair validPair, boolean sentUseCandidateInRequest) {
        if (this.m_iceAgent.isControlling() && sentUseCandidateInRequest) {
            this.m_log.debug("Nominating pair on controlling agent.");
            validPair.nominate();
            this.m_iceAgent.onNominatedPair(validPair, this.m_mediaStream);
            return true;
        }
        if (!this.m_iceAgent.isControlling() && this.m_pair.useCandidateSet()) {
            this.m_log.debug("Nominating new pair on controlled agent!!");
            this.m_pair.nominate();
            this.m_iceAgent.onNominatedPair(this.m_pair, this.m_mediaStream);
            return true;
        }
        this.m_log.debug("Not nominating pair.");
        return false;
    }

    private boolean equalsOriginalPair(IceCandidatePair pair, InetSocketAddress newLocalAddress, InetSocketAddress newRemoteAddress) {
        InetSocketAddress oldLocalAddress = pair.getLocalCandidate().getSocketAddress();
        InetSocketAddress oldRemoteAddress = pair.getRemoteCandidate().getSocketAddress();
        return newLocalAddress.equals(oldLocalAddress) && newRemoteAddress.equals(oldRemoteAddress);
    }

    private static IceCandidate createRemoteCandidate(IceCandidate remoteCandidate, final long remotePriority) {
        final InetSocketAddress remoteAddress = remoteCandidate.getSocketAddress();
        final String foundation = remoteCandidate.getFoundation();
        final boolean controlling = remoteCandidate.isControlling();
        final int componentId = remoteCandidate.getComponentId();
        final InetAddress relatedAddress = remoteCandidate.getRelatedAddress();
        final int relatedPort = remoteCandidate.getRelatedPort();
        IceCandidateVisitorAdapter<IceCandidate> visitor = new IceCandidateVisitorAdapter<IceCandidate>(){

            @Override
            public IceCandidate visitTcpHostPassiveCandidate(IceTcpHostPassiveCandidate candidate) {
                return new IceTcpHostPassiveCandidate(remoteAddress, foundation, controlling, remotePriority, componentId);
            }

            @Override
            public IceCandidate visitTcpPeerReflexiveCandidate(IceTcpPeerReflexiveCandidate candidate) {
                return new IceTcpPeerReflexiveCandidate(remoteAddress, foundation, componentId, controlling, remotePriority);
            }

            @Override
            public IceCandidate visitTcpRelayPassiveCandidate(IceTcpRelayPassiveCandidate candidate) {
                return new IceTcpRelayPassiveCandidate(remoteAddress, foundation, relatedAddress, relatedPort, controlling, remotePriority, componentId);
            }

            @Override
            public IceCandidate visitTcpServerReflexiveSoCandidate(IceTcpServerReflexiveSoCandidate candidate) {
                return new IceTcpServerReflexiveSoCandidate(remoteAddress, foundation, relatedAddress, relatedPort, controlling, remotePriority, componentId);
            }

            @Override
            public IceCandidate visitUdpHostCandidate(IceUdpHostCandidate candidate) {
                return new IceUdpHostCandidate(remoteAddress, foundation, remotePriority, controlling, componentId);
            }

            @Override
            public IceCandidate visitUdpPeerReflexiveCandidate(IceUdpPeerReflexiveCandidate candidate) {
                return new IceUdpPeerReflexiveCandidate(remoteAddress, foundation, componentId, controlling, remotePriority);
            }

            @Override
            public IceCandidate visitUdpRelayCandidate(IceUdpRelayCandidate candidate) {
                return new IceUdpRelayCandidate(remoteAddress, foundation, remotePriority, controlling, componentId, relatedAddress, relatedPort);
            }

            @Override
            public IceCandidate visitUdpServerReflexiveCandidate(IceUdpServerReflexiveCandidate candidate) {
                return new IceUdpServerReflexiveCandidate(remoteAddress, foundation, relatedAddress, relatedPort, controlling, remotePriority, componentId);
            }
        };
        return remoteCandidate.accept(visitor);
    }
}

