/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import org.lastbamboo.common.ice.IceAgent;
import org.lastbamboo.common.ice.IceBindingRequestTracker;
import org.lastbamboo.common.ice.IceBindingRequestTrackerImpl;
import org.lastbamboo.common.ice.IceStunCheckerFactory;
import org.lastbamboo.common.ice.IceStunConnectivityCheckerImpl;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.stun.stack.message.StunMessageVisitor;
import org.littleshoot.stun.stack.message.StunMessageVisitorFactory;
import org.littleshoot.stun.stack.transaction.StunTransactionTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IceStunConnectivityCheckerFactoryImpl<T>
implements StunMessageVisitorFactory<T> {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final IceAgent m_iceAgent;
    private final StunTransactionTracker<T> m_transactionTracker;
    private final IceStunCheckerFactory m_checkerFactory;
    private final IceBindingRequestTracker m_bindingRequestTracker = new IceBindingRequestTrackerImpl();

    public IceStunConnectivityCheckerFactoryImpl(IceAgent iceAgent, StunTransactionTracker<T> transactionTracker, IceStunCheckerFactory checkerFactory) {
        this.m_iceAgent = iceAgent;
        this.m_transactionTracker = transactionTracker;
        this.m_checkerFactory = checkerFactory;
    }

    public StunMessageVisitor<T> createVisitor(IoSession session) {
        this.m_log.debug("Creating new message visitor for session: {}", (Object)session);
        return new IceStunConnectivityCheckerImpl<T>(this.m_iceAgent, session, this.m_transactionTracker, this.m_checkerFactory, this.m_bindingRequestTracker);
    }
}

