/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.lastbamboo.common.stun.client.StunClient;
import org.lastbamboo.common.stun.client.UdpStunClient;
import org.lastbamboo.common.stun.server.StunServer;
import org.lastbamboo.common.stun.server.UdpStunServer;
import org.littleshoot.mina.common.IoHandler;
import org.littleshoot.mina.common.IoServiceListener;
import org.littleshoot.mina.filter.codec.ProtocolCodecFactory;
import org.littleshoot.stun.stack.message.BindingRequest;
import org.littleshoot.stun.stack.message.StunMessage;
import org.littleshoot.stun.stack.transaction.StunTransactionTracker;
import org.littleshoot.util.CandidateProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IceStunUdpPeer
implements StunClient,
StunServer {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final StunClient m_stunClient;
    private final StunServer m_stunServer;
    private InetSocketAddress m_serverReflexiveAddress;

    public IceStunUdpPeer(ProtocolCodecFactory demuxingCodecFactory, IoHandler ioHandler, boolean controlling, StunTransactionTracker<StunMessage> transactionTracker, CandidateProvider<InetSocketAddress> stunServerCandidateProvider) throws IOException {
        this.m_stunClient = new UdpStunClient(transactionTracker, ioHandler, stunServerCandidateProvider);
        this.m_stunClient.connect();
        this.m_serverReflexiveAddress = this.m_stunClient.getServerReflexiveAddress();
        if (this.m_serverReflexiveAddress == null) {
            String msg = "Could not get server reflexive address.  Did STUN server respond??";
            this.m_log.error("Could not get server reflexive address.  Did STUN server respond??");
            throw new IOException("Could not get server reflexive address.  Did STUN server respond??");
        }
        String controllingString = controlling ? "-Controlling" : "-Not-Controlling";
        this.m_stunServer = new UdpStunServer(demuxingCodecFactory, ioHandler, controllingString);
        this.m_stunServer.start(this.m_stunClient.getHostAddress());
        this.m_log.debug("Started STUN CLIENT on local address: {}", (Object)this.m_stunClient.getHostAddress());
        this.m_log.debug("Started STUN SERVER on local address: {}", (Object)this.m_stunServer.getBoundAddress());
    }

    public void connect() throws IOException {
    }

    public InetSocketAddress getHostAddress() {
        return this.m_stunClient.getHostAddress();
    }

    public InetSocketAddress getRelayAddress() {
        return this.m_stunClient.getRelayAddress();
    }

    public InetSocketAddress getServerReflexiveAddress() {
        this.m_log.info("Getting server reflexive address");
        return this.m_serverReflexiveAddress;
    }

    public InetAddress getStunServerAddress() {
        return this.m_stunClient.getStunServerAddress();
    }

    public StunMessage write(BindingRequest request, InetSocketAddress remoteAddress) {
        this.m_log.error("Unsupported!!!!!!!");
        throw new IllegalStateException("Not implemented.");
    }

    public StunMessage write(BindingRequest request, InetSocketAddress remoteAddress, long rto) {
        this.m_log.error("Unsupported!!!!!!!");
        throw new IllegalStateException("Not implemented.");
    }

    public void start() {
    }

    public void start(InetSocketAddress bindAddress) {
    }

    public InetSocketAddress getBoundAddress() {
        return this.m_stunServer.getBoundAddress();
    }

    public void addIoServiceListener(IoServiceListener serviceListener) {
        this.m_stunClient.addIoServiceListener(serviceListener);
        this.m_stunServer.addIoServiceListener(serviceListener);
    }

    public void close() {
        this.m_log.debug("Closing ICE UDP peer...");
        this.m_stunClient.close();
        this.m_stunServer.close();
    }

    public boolean hostPortMapped() {
        return false;
    }

    public StunServer getStunServer() {
        return this.m_stunServer;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

