/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.lastbamboo.common.ice.MappedServerSocket;
import org.lastbamboo.common.portmapping.NatPmpService;
import org.lastbamboo.common.portmapping.PortMapListener;
import org.lastbamboo.common.portmapping.PortMappingProtocol;
import org.lastbamboo.common.portmapping.UpnpService;
import org.littleshoot.util.NetworkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedTcpAnswererServer
implements PortMapListener,
MappedServerSocket {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private int externalPort;
    private final InetSocketAddress serverAddress;
    private boolean isPortMapped = false;

    public MappedTcpAnswererServer(NatPmpService natPmpService, UpnpService upnpService, InetSocketAddress serverAddress) {
        InetAddress local;
        if (serverAddress.getPort() == 0) {
            throw new IllegalArgumentException("Cannot map ephemeral port");
        }
        int port = serverAddress.getPort();
        try {
            local = NetworkUtils.getLocalHost();
        }
        catch (UnknownHostException e) {
            this.log.error("Could not get localhost?", (Throwable)e);
            throw new Error("Could not get localhost address!", e);
        }
        this.serverAddress = new InetSocketAddress(local, port);
        this.externalPort = port;
        if (!NetworkUtils.isPublicAddress((InetAddress)local)) {
            this.log.debug("Mapping port: {}", (Object)port);
            upnpService.addUpnpMapping(PortMappingProtocol.TCP, port, port, (PortMapListener)this);
            natPmpService.addNatPmpMapping(PortMappingProtocol.TCP, port, port, (PortMapListener)this);
        } else {
            this.isPortMapped = true;
        }
    }

    @Override
    public InetSocketAddress getHostAddress() {
        return this.serverAddress;
    }

    public void onPortMap(int port) {
        this.log.info("Received port mapped: {}", (Object)port);
        this.externalPort = port;
        if (this.externalPort > 0) {
            this.isPortMapped = true;
        }
    }

    public void onPortMapError() {
        this.log.info("Got port map error.");
        this.isPortMapped = false;
    }

    @Override
    public boolean isPortMapped() {
        return this.isPortMapped;
    }

    @Override
    public int getMappedPort() {
        return this.externalPort;
    }
}

