/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import java.net.InetSocketAddress;
import java.net.ServerSocket;
import org.lastbamboo.common.ice.MappedServerSocket;
import org.lastbamboo.common.portmapping.PortMapListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortMappedServerSocket
implements PortMapListener,
MappedServerSocket {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ServerSocket serverSocket;
    private int externalPort;
    private boolean hasMappedPort;
    private final boolean isPublic;

    public PortMappedServerSocket(ServerSocket serverSocket, boolean isPublic) {
        this.serverSocket = serverSocket;
        this.isPublic = isPublic;
        if (isPublic) {
            this.hasMappedPort = true;
        }
    }

    public void onPortMap(int port) {
        this.log.info("Got port mapped!! " + port);
        this.externalPort = port;
        this.hasMappedPort = true;
    }

    public void onPortMapError() {
        this.log.info("Error mapping port...");
        if (!this.isPublic) {
            this.hasMappedPort = false;
        }
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    @Override
    public boolean isPortMapped() {
        return this.hasMappedPort;
    }

    @Override
    public int getMappedPort() {
        return this.externalPort;
    }

    @Override
    public InetSocketAddress getHostAddress() {
        return (InetSocketAddress)this.serverSocket.getLocalSocketAddress();
    }

    public String toString() {
        return "PortMappedServerSocket [serverSocket=" + this.serverSocket + ", externalPort=" + this.externalPort + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.externalPort;
        result = 31 * result + (this.serverSocket == null ? 0 : this.serverSocket.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortMappedServerSocket other = (PortMappedServerSocket)obj;
        if (this.externalPort != other.externalPort) {
            return false;
        }
        return !(this.serverSocket == null ? other.serverSocket != null : !this.serverSocket.equals(other.serverSocket));
    }
}

