/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice.candidate;

import java.util.Collection;
import org.lastbamboo.common.ice.candidate.IceCandidate;
import org.lastbamboo.common.ice.candidate.IceCandidateVisitor;
import org.lastbamboo.common.ice.candidate.IceTcpActiveCandidate;
import org.lastbamboo.common.ice.candidate.IceTcpHostPassiveCandidate;
import org.lastbamboo.common.ice.candidate.IceTcpPeerReflexiveCandidate;
import org.lastbamboo.common.ice.candidate.IceTcpRelayPassiveCandidate;
import org.lastbamboo.common.ice.candidate.IceTcpServerReflexiveSoCandidate;
import org.lastbamboo.common.ice.candidate.IceUdpHostCandidate;
import org.lastbamboo.common.ice.candidate.IceUdpPeerReflexiveCandidate;
import org.lastbamboo.common.ice.candidate.IceUdpRelayCandidate;
import org.lastbamboo.common.ice.candidate.IceUdpServerReflexiveCandidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IceCandidateVisitorAdapter<T>
implements IceCandidateVisitor<T> {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final boolean m_warn;

    public IceCandidateVisitorAdapter() {
        this.m_warn = true;
    }

    public IceCandidateVisitorAdapter(boolean warn) {
        this.m_warn = warn;
    }

    @Override
    public void visitCandidates(Collection<IceCandidate> candidates) {
        if (this.m_warn) {
            this.m_log.warn("Not handling visit all candidates");
        }
    }

    @Override
    public T visitTcpActiveCandidate(IceTcpActiveCandidate candidate) {
        this.m_log.info("Visiting unhandled candidate: {}", (Object)candidate);
        return null;
    }

    @Override
    public T visitTcpHostPassiveCandidate(IceTcpHostPassiveCandidate candidate) {
        if (this.m_warn) {
            this.m_log.info("Visiting unhandled candidate: {}", (Object)candidate);
        } else {
            this.m_log.debug("Visiting unhandled candidate: {}", (Object)candidate);
        }
        return null;
    }

    @Override
    public T visitTcpRelayPassiveCandidate(IceTcpRelayPassiveCandidate candidate) {
        if (this.m_warn) {
            this.m_log.info("Visiting unhandled candidate: {}", (Object)candidate);
        } else {
            this.m_log.debug("Visiting unhandled candidate: {}", (Object)candidate);
        }
        return null;
    }

    @Override
    public T visitTcpServerReflexiveSoCandidate(IceTcpServerReflexiveSoCandidate candidate) {
        if (this.m_warn) {
            this.m_log.info("Visiting unhandled candidate: {}", (Object)candidate);
        } else {
            this.m_log.debug("Visiting unhandled candidate: {}", (Object)candidate);
        }
        return null;
    }

    @Override
    public T visitTcpPeerReflexiveCandidate(IceTcpPeerReflexiveCandidate candidate) {
        if (this.m_warn) {
            this.m_log.info("Visiting unhandled candidate: {}", (Object)candidate);
        } else {
            this.m_log.debug("Visiting unhandled candidate: {}", (Object)candidate);
        }
        return null;
    }

    @Override
    public T visitUdpHostCandidate(IceUdpHostCandidate candidate) {
        if (this.m_warn) {
            this.m_log.info("Visiting unhandled candidate: {}", (Object)candidate);
        } else {
            this.m_log.debug("Visiting unhandled candidate: {}", (Object)candidate);
        }
        return null;
    }

    @Override
    public T visitUdpPeerReflexiveCandidate(IceUdpPeerReflexiveCandidate candidate) {
        if (this.m_warn) {
            this.m_log.info("Visiting unhandled candidate: {}", (Object)candidate);
        } else {
            this.m_log.debug("Visiting unhandled candidate: {}", (Object)candidate);
        }
        return null;
    }

    @Override
    public T visitUdpRelayCandidate(IceUdpRelayCandidate candidate) {
        if (this.m_warn) {
            this.m_log.info("Visiting unhandled candidate: {}", (Object)candidate);
        } else {
            this.m_log.debug("Visiting unhandled candidate: {}", (Object)candidate);
        }
        return null;
    }

    @Override
    public T visitUdpServerReflexiveCandidate(IceUdpServerReflexiveCandidate candidate) {
        if (this.m_warn) {
            this.m_log.info("Visiting unhandled candidate: {}", (Object)candidate);
        } else {
            this.m_log.debug("Visiting unhandled candidate: {}", (Object)candidate);
        }
        return null;
    }
}

