/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice.candidate;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.lastbamboo.common.ice.IcePriorityCalculator;
import org.lastbamboo.common.ice.IceTransportProtocol;
import org.lastbamboo.common.ice.candidate.AbstractIceCandidate;
import org.lastbamboo.common.ice.candidate.IceCandidateType;
import org.lastbamboo.common.ice.candidate.IceCandidateVisitor;
import org.lastbamboo.common.ice.candidate.IceFoundationCalculator;

public class IceUdpRelayCandidate
extends AbstractIceCandidate {
    public IceUdpRelayCandidate(InetSocketAddress relayAddress, InetAddress stunServerAddress, InetAddress relatedAddress, int relatedPort, boolean controlling) {
        super(relayAddress, IceFoundationCalculator.calculateFoundation(IceCandidateType.RELAYED, relayAddress.getAddress(), IceTransportProtocol.UDP, stunServerAddress), IceCandidateType.RELAYED, IceTransportProtocol.UDP, IcePriorityCalculator.calculatePriority(IceCandidateType.RELAYED, IceTransportProtocol.UDP), controlling, 1, null, relatedAddress, relatedPort);
    }

    public IceUdpRelayCandidate(InetSocketAddress relayAddress, String foundation, long priority, boolean controlling, int componentId, InetAddress relatedAddress, int relatedPort) {
        super(relayAddress, foundation, IceCandidateType.RELAYED, IceTransportProtocol.UDP, priority, controlling, componentId, null, relatedAddress, relatedPort);
    }

    @Override
    public <T> T accept(IceCandidateVisitor<T> visitor) {
        return visitor.visitUdpRelayCandidate(this);
    }
}

