/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import com.barchart.udt.net.NetServerSocketUDT;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.lastbamboo.common.ice.IceAgent;
import org.lastbamboo.common.ice.IceStunUdpPeer;
import org.lastbamboo.common.ice.NetSocketUDTWrapper;
import org.lastbamboo.common.ice.UdpSocketFactory;
import org.lastbamboo.common.offer.answer.OfferAnswerListener;
import org.lastbamboo.common.stun.server.StunServer;
import org.littleshoot.mina.common.IoAcceptor;
import org.littleshoot.mina.common.IoService;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.transport.socket.nio.support.DatagramSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BarchartUdtSocketFactory
implements UdpSocketFactory<Socket> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final ExecutorService threadPool = Executors.newCachedThreadPool(new ThreadFactory(){
        private volatile int count = 0;

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "UDT-Socket-Thread-" + this.count);
            t.setDaemon(true);
            ++this.count;
            return t;
        }
    });
    private final SocketFactory sslSocketFactory;

    public BarchartUdtSocketFactory(SocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    @Override
    public void newEndpoint(final IoSession session, boolean controlling, final OfferAnswerListener<Socket> socketListener, IceStunUdpPeer stunUdpPeer, IceAgent iceAgent) {
        this.log.info("Creating new Barchart UDT Socket");
        if (session == null) {
            this.log.error("Null session: {}", (Object)session);
            return;
        }
        if (controlling) {
            long sleepTime = 1200L;
            this.log.info("Client side sleeping for {} milliseconds", (Object)1200L);
            try {
                Thread.sleep(1200L);
            }
            catch (InterruptedException e) {
                this.log.warn("Sleep interrupted?", (Throwable)e);
            }
        }
        this.clear(session, stunUdpPeer, iceAgent);
        if (!controlling) {
            this.log.debug("Creating UDT socket on CONTROLLED agent.");
            Runnable clientRunner = new Runnable(){

                @Override
                public void run() {
                    try {
                        BarchartUdtSocketFactory.this.openServerSocket(session, (OfferAnswerListener<Socket>)socketListener);
                    }
                    catch (Throwable t) {
                        BarchartUdtSocketFactory.this.log.error("Barchart socket exception", t);
                    }
                }
            };
            threadPool.execute(clientRunner);
        } else {
            this.log.debug("Creating UDT socket on CONTROLLING agent.");
            this.log.debug("Listening on: {}", (Object)session);
            Runnable socketRunner = new Runnable(){

                @Override
                public void run() {
                    try {
                        BarchartUdtSocketFactory.this.openClientSocket(session, (OfferAnswerListener<Socket>)socketListener);
                    }
                    catch (Throwable t) {
                        BarchartUdtSocketFactory.this.log.error("Barchart socket exception", t);
                    }
                }
            };
            threadPool.execute(socketRunner);
        }
    }

    protected void openClientSocket(IoSession session, OfferAnswerListener<Socket> socketListener) throws IOException {
        InetSocketAddress local = (InetSocketAddress)session.getLocalAddress();
        InetSocketAddress remote = (InetSocketAddress)session.getRemoteAddress();
        this.log.info("Session local was: {}", (Object)local);
        this.log.info("Binding to port: {}", (Object)local.getPort());
        NetSocketUDTWrapper clientSocket = new NetSocketUDTWrapper();
        this.log.info("Binding to address and port");
        ((Socket)((Object)clientSocket)).bind(new InetSocketAddress(local.getAddress(), local.getPort()));
        this.log.info("About to connect...");
        ((Socket)((Object)clientSocket)).connect(new InetSocketAddress(remote.getAddress(), remote.getPort()));
        this.log.info("Connected...notifying listener");
        if (this.sslSocketFactory instanceof SSLSocketFactory) {
            SSLSocket sslSocket = (SSLSocket)((SSLSocketFactory)this.sslSocketFactory).createSocket((Socket)((Object)clientSocket), ((Socket)((Object)clientSocket)).getInetAddress().getHostAddress(), ((Socket)((Object)clientSocket)).getPort(), true);
            sslSocket.setUseClientMode(true);
            sslSocket.startHandshake();
            socketListener.onUdpSocket((Object)sslSocket);
        } else {
            socketListener.onUdpSocket((Object)clientSocket);
        }
        this.log.info("Exiting...");
    }

    protected void openServerSocket(IoSession session, OfferAnswerListener<Socket> socketListener) throws IOException {
        InetSocketAddress local = (InetSocketAddress)session.getLocalAddress();
        this.log.info("Session local was: {}", (Object)local);
        this.log.info("Binding to port: {}", (Object)local.getPort());
        NetServerSocketUDT ss = new NetServerSocketUDT();
        ss.bind(new InetSocketAddress(local.getAddress(), local.getPort()));
        Socket sock = ss.accept();
        if (this.sslSocketFactory instanceof SSLSocketFactory) {
            SSLSocket sslSocket = (SSLSocket)((SSLSocketFactory)this.sslSocketFactory).createSocket(sock, sock.getInetAddress().getHostAddress(), sock.getPort(), true);
            sslSocket.setUseClientMode(false);
            sslSocket.startHandshake();
            threadPool.execute(new RequestRunner(socketListener, sslSocket));
        } else {
            threadPool.execute(new RequestRunner(socketListener, sock));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(IoSession session, IceStunUdpPeer stunUdpPeer, IceAgent iceAgent) {
        this.log.info("Closing ICE agent");
        iceAgent.close();
        this.log.info("Clearing session: {}", (Object)session);
        DatagramSessionImpl dgSession = (DatagramSessionImpl)session;
        DatagramChannel dgChannel = dgSession.getChannel();
        session.close().join(10000L);
        StunServer stunServer = stunUdpPeer.getStunServer();
        stunServer.close();
        try {
            IoService service = session.getService();
            this.log.info("Service is: {}", (Object)service);
            if (IoAcceptor.class.isAssignableFrom(service.getClass())) {
                this.log.info("Unbinding all!!");
                IoAcceptor acceptor = (IoAcceptor)service;
                acceptor.unbindAll();
            }
            session.getService().getFilterChain().clear();
            dgChannel.disconnect();
            dgChannel.close();
            this.log.info("Open: " + dgChannel.isOpen());
            this.log.info("Connected: " + dgChannel.isConnected());
            this.log.info("Sleeping on channel to make sure it unbinds");
            Thread.sleep(400L);
            this.log.info("Closed channel");
        }
        catch (Exception e) {
            this.log.error("Error clearing session!!", (Throwable)e);
        }
        finally {
            stunUdpPeer.close();
        }
    }

    private static class RequestRunner
    implements Runnable {
        private final Logger localLog = LoggerFactory.getLogger(this.getClass());
        private final Socket sock;
        private final OfferAnswerListener<Socket> socketListener;

        public RequestRunner(OfferAnswerListener<Socket> socketListener, Socket sock) {
            this.socketListener = socketListener;
            this.sock = sock;
        }

        @Override
        public void run() {
            this.localLog.info("NOTIFYING SOCKET LISTENER!!");
            this.socketListener.onUdpSocket((Object)this.sock);
        }
    }
}

