/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.lastbamboo.common.ice.ExistingSessionIceCandidatePairFactory;
import org.lastbamboo.common.ice.IceAgent;
import org.lastbamboo.common.ice.IceCheckList;
import org.lastbamboo.common.ice.IceCheckListState;
import org.lastbamboo.common.ice.IceCheckScheduler;
import org.lastbamboo.common.ice.IceMediaStream;
import org.lastbamboo.common.ice.IceStunClientCandidateProcessor;
import org.lastbamboo.common.ice.candidate.IceCandidate;
import org.lastbamboo.common.ice.candidate.IceCandidatePair;
import org.lastbamboo.common.ice.candidate.IceCandidatePairState;
import org.littleshoot.util.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IceCheckSchedulerImpl
implements IceCheckScheduler {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final IceCheckList m_checkList;
    private final IceMediaStream m_mediaStream;
    private final IceAgent m_agent;
    private final ExistingSessionIceCandidatePairFactory m_existingSessionPairFactory;
    private volatile boolean m_queueEmpty = false;
    private Timer m_timer;
    private final Object m_queueLock = new Object();
    private static final ExecutorService threadPool = Executors.newCachedThreadPool(new ThreadFactory(){
        private volatile int threadNumber = 0;

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "IceCheckSchedulerImpl-Timer-ThreadPool-" + this.threadNumber);
            t.setDaemon(true);
            ++this.threadNumber;
            return t;
        }
    });
    private final String timerName;

    public IceCheckSchedulerImpl(IceAgent agent, IceMediaStream stream, IceCheckList checkList, ExistingSessionIceCandidatePairFactory existingSessionPairFactory) {
        this.m_agent = agent;
        this.m_mediaStream = stream;
        this.m_checkList = checkList;
        this.m_existingSessionPairFactory = existingSessionPairFactory;
        String offererOrAnswerer = this.m_agent.isControlling() ? "ICE-Controlling" : "ICE-Not-Controlling";
        this.timerName = offererOrAnswerer + "-Timer";
        this.m_timer = new Timer(this.timerName, true);
    }

    @Override
    public void scheduleChecks() {
        this.m_log.debug("Scheduling checks...");
        TimerTask task = this.createTimerTask(this.m_timer);
        this.m_timer.schedule(task, 0L);
    }

    private TimerTask createTimerTask(final Timer timer) {
        return new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (IceCheckSchedulerImpl.this.m_agent.isClosed()) {
                    IceCheckSchedulerImpl.this.m_log.debug("UDP agent is closed, not checking next pair");
                    return;
                }
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        IceCheckSchedulerImpl.this.m_log.debug("About to check pair...");
                        try {
                            IceCheckSchedulerImpl.this.checkPair(timer);
                        }
                        catch (Throwable t) {
                            IceCheckSchedulerImpl.this.m_log.warn("Caught throwable in check", t);
                        }
                    }
                };
                threadPool.submit(runner);
                Object object = IceCheckSchedulerImpl.this.m_queueLock;
                synchronized (object) {
                    if (IceCheckSchedulerImpl.this.m_queueEmpty) {
                        IceCheckSchedulerImpl.this.m_log.info("WAITING ON QUEUE - NO PAIRS");
                        try {
                            IceCheckSchedulerImpl.this.m_queueLock.wait(10000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (IceCheckSchedulerImpl.this.m_queueEmpty) {
                            timer.cancel();
                            IceCheckSchedulerImpl.this.m_agent.onNoMorePairs();
                        }
                    }
                }
            }
        };
    }

    private void checkPair(Timer timer) {
        if (this.m_agent.isClosed()) {
            this.m_log.debug("ICE agent is closed");
            timer.cancel();
            return;
        }
        if (this.m_checkList.getState() == IceCheckListState.COMPLETED) {
            this.m_log.debug("Checks are completed!  Returning");
            timer.cancel();
            return;
        }
        TimerTask task = this.createTimerTask(timer);
        int Ta_i = 500;
        timer.schedule(task, this.m_agent.calculateDelay(500));
        IceCandidatePair activePair = this.getNextPair();
        if (activePair == null) {
            this.m_log.debug("No more active pairs...");
            this.m_queueEmpty = true;
            timer.cancel();
        } else {
            this.m_log.debug("Scheduling new timer task...");
            this.m_log.debug("About to perform check on:{}", (Object)activePair);
            this.performCheck(activePair);
        }
    }

    private void performCheck(IceCandidatePair pair) {
        IceCandidate local = pair.getLocalCandidate();
        IceStunClientCandidateProcessor processor = new IceStunClientCandidateProcessor(this.m_agent, this.m_mediaStream, pair, this.m_existingSessionPairFactory);
        processor.processLocalCandidate(local);
    }

    private IceCandidatePair getNextPair() {
        IceCandidatePair triggeredPair = this.m_checkList.removeTopTriggeredPair();
        if (triggeredPair != null) {
            this.m_log.debug("Scheduler using TRIGGERED pair...");
            return triggeredPair;
        }
        IceCandidatePair waitingPair = this.getPairInState(IceCandidatePairState.WAITING);
        if (waitingPair == null) {
            IceCandidatePair frozen = this.getPairInState(IceCandidatePairState.FROZEN);
            if (frozen != null) {
                this.m_log.debug("Scheduler using FROZEN pair...");
                frozen.setState(IceCandidatePairState.WAITING);
                return frozen;
            }
            return null;
        }
        this.m_log.debug("Scheduler using WAITING pair...");
        return waitingPair;
    }

    private IceCandidatePair getPairInState(final IceCandidatePairState state) {
        Predicate<IceCandidatePair> pred = new Predicate<IceCandidatePair>(){

            public boolean evaluate(IceCandidatePair pair) {
                return pair.getState() == state;
            }
        };
        return this.m_checkList.selectPair(pred);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPair() {
        Object object = this.m_queueLock;
        synchronized (object) {
            if (this.m_queueEmpty) {
                this.m_timer = new Timer(this.timerName + "-Restarted", true);
                this.m_queueEmpty = false;
                this.scheduleChecks();
            }
            this.m_queueLock.notifyAll();
        }
    }
}

