/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.lastbamboo.common.ice.GeneralIceMediaStreamFactoryImpl;
import org.lastbamboo.common.ice.IceAgent;
import org.lastbamboo.common.ice.IceMediaStream;
import org.lastbamboo.common.ice.IceMediaStreamFactory;
import org.lastbamboo.common.ice.IceUdpConnectException;
import org.lastbamboo.common.offer.answer.IceMediaStreamDesc;
import org.lastbamboo.common.turn.client.TurnClientListener;
import org.lastbamboo.common.turn.http.server.ServerDataFeeder;
import org.littleshoot.util.CandidateProvider;
import org.littleshoot.util.NetworkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IceMediaStreamFactoryImpl
implements IceMediaStreamFactory {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final CandidateProvider<InetSocketAddress> m_stunServerCandidateProvider;

    public IceMediaStreamFactoryImpl(CandidateProvider<InetSocketAddress> stunServerCandidateProvider) {
        this.m_stunServerCandidateProvider = stunServerCandidateProvider;
    }

    @Override
    public IceMediaStream newStream(IceAgent iceAgent, IceMediaStreamDesc streamDesc) throws IceUdpConnectException {
        InetAddress serverAddress;
        try {
            serverAddress = NetworkUtils.getLocalHost();
        }
        catch (UnknownHostException e) {
            this.m_log.warn("Could not get local host!!", (Throwable)e);
            return null;
        }
        InetSocketAddress httpServerAddress = new InetSocketAddress(serverAddress, 8108);
        ServerDataFeeder delegateListener = new ServerDataFeeder(httpServerAddress);
        GeneralIceMediaStreamFactoryImpl streamFactory = new GeneralIceMediaStreamFactoryImpl(this.m_stunServerCandidateProvider);
        IceMediaStream stream = streamFactory.newIceMediaStream(streamDesc, iceAgent, (TurnClientListener)delegateListener);
        return stream;
    }
}

