/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.commons.lang.math.RandomUtils;
import org.lastbamboo.common.ice.IceAgent;
import org.lastbamboo.common.ice.IceCheckList;
import org.lastbamboo.common.ice.IceCheckListState;
import org.lastbamboo.common.ice.IceCheckScheduler;
import org.lastbamboo.common.ice.IceMediaStream;
import org.lastbamboo.common.ice.IceState;
import org.lastbamboo.common.ice.IceStunUdpPeer;
import org.lastbamboo.common.ice.candidate.IceCandidate;
import org.lastbamboo.common.ice.candidate.IceCandidateGatherer;
import org.lastbamboo.common.ice.candidate.IceCandidatePair;
import org.lastbamboo.common.ice.candidate.IceCandidatePairState;
import org.lastbamboo.common.ice.candidate.IceUdpPeerReflexiveCandidate;
import org.lastbamboo.common.ice.sdp.IceCandidateSdpEncoder;
import org.lastbamboo.common.offer.answer.IceMediaStreamDesc;
import org.littleshoot.mina.common.IoHandler;
import org.littleshoot.mina.common.IoService;
import org.littleshoot.mina.common.IoServiceConfig;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.stun.stack.message.BindingRequest;
import org.littleshoot.stun.stack.message.attributes.StunAttributeType;
import org.littleshoot.stun.stack.message.attributes.ice.IcePriorityAttribute;
import org.littleshoot.util.Closure;
import org.littleshoot.util.Predicate;
import org.littleshoot.util.mina.MinaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IceMediaStreamImpl
implements IceMediaStream {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private IceCheckList m_checkList;
    private final Queue<IceCandidatePair> m_validPairs = new PriorityQueue<IceCandidatePair>();
    private final Queue<IceCandidatePair> m_nominatedPairs = new PriorityQueue<IceCandidatePair>();
    private Collection<IceCandidate> m_localCandidates;
    private final IceAgent m_iceAgent;
    private final IceMediaStreamDesc m_desc;
    private final Collection<IceCandidate> m_remoteCandidates = new ArrayList<IceCandidate>(10);
    private Collection<IceCandidate> m_remoteSdpCandidates = new ArrayList<IceCandidate>(10);
    private final IceCandidateGatherer m_gatherer;
    private IceCheckScheduler m_checkScheduler;
    private boolean m_closed;
    private final IceStunUdpPeer m_udpPeer;

    public IceMediaStreamImpl(IceAgent iceAgent, IceMediaStreamDesc streamDesc, IceCandidateGatherer gatherer, IceStunUdpPeer udpPeer) {
        this.m_iceAgent = iceAgent;
        this.m_desc = streamDesc;
        this.m_gatherer = gatherer;
        this.m_udpPeer = udpPeer;
    }

    @Override
    public void start(IceCheckList checkList, Collection<IceCandidate> localCandidates, IceCheckScheduler scheduler) {
        this.m_localCandidates = localCandidates;
        this.m_checkList = checkList;
        this.m_checkScheduler = scheduler;
    }

    @Override
    public byte[] encodeCandidates() {
        IceCandidateSdpEncoder encoder = new IceCandidateSdpEncoder(this.m_desc.getMimeContentType(), this.m_desc.getMimeContentSubtype());
        encoder.visitCandidates(this.getLocalCandidates());
        return encoder.getSdp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void establishStream(Collection<IceCandidate> remoteCandidates) {
        Collection<IceCandidate> collection = this.m_remoteCandidates;
        synchronized (collection) {
            Collection<IceCandidate> collection2 = this.m_remoteSdpCandidates;
            synchronized (collection2) {
                Collection<IceCandidate> collection3 = remoteCandidates;
                synchronized (collection3) {
                    this.m_remoteCandidates.addAll(remoteCandidates);
                    this.m_remoteSdpCandidates.addAll(remoteCandidates);
                    this.m_remoteSdpCandidates = Collections.unmodifiableCollection(this.m_remoteSdpCandidates);
                }
            }
        }
        this.m_checkList.formCheckList(remoteCandidates);
        this.processPairGroups();
        if (this.m_closed) {
            this.m_log.info("Already closed - not scheduling checks!!");
            return;
        }
        this.m_checkScheduler.scheduleChecks();
        this.m_checkList.check();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IceCandidate addRemotePeerReflexive(BindingRequest request, InetSocketAddress localAddress, InetSocketAddress remoteAddress, boolean isUdp) {
        Map attributes = request.getAttributes();
        IcePriorityAttribute priorityAttribute = (IcePriorityAttribute)attributes.get(StunAttributeType.ICE_PRIORITY);
        long priority = priorityAttribute.getPriority();
        String foundation = String.valueOf(RandomUtils.nextLong());
        IceCandidate localCandidate = this.getLocalCandidate(localAddress, isUdp);
        if (localCandidate == null) {
            IceMediaStreamImpl iceMediaStreamImpl = this;
            synchronized (iceMediaStreamImpl) {
                this.m_log.warn("Could not find local candidate " + localAddress + " in: " + this.getLocalCandidates() + ".  Aborting.");
            }
            return null;
        }
        int componentId = localCandidate.getComponentId();
        this.m_log.debug("Creating new peer reflexive candidate");
        IceUdpPeerReflexiveCandidate prc = new IceUdpPeerReflexiveCandidate(remoteAddress, foundation, componentId, this.m_iceAgent.isControlling(), priority);
        this.addRemoteCandidate(prc);
        return prc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRemoteCandidate(IceCandidate candidate) {
        Collection<IceCandidate> collection = this.m_remoteCandidates;
        synchronized (collection) {
            this.m_remoteCandidates.add(candidate);
        }
    }

    private void processPairGroups() {
        final HashMap groupsMap = new HashMap();
        Closure<IceCandidatePair> groupClosure = new Closure<IceCandidatePair>(){

            public void execute(IceCandidatePair pair) {
                List<IceCandidatePair> foundationPairs;
                String foundation = pair.getFoundation();
                if (groupsMap.containsKey(foundation)) {
                    foundationPairs = (List)groupsMap.get(foundation);
                } else {
                    foundationPairs = new LinkedList();
                    groupsMap.put(foundation, foundationPairs);
                }
                foundationPairs.add(pair);
            }
        };
        this.m_checkList.executeOnPairs(groupClosure);
        Collection groups = groupsMap.values();
        this.m_log.debug(groups.size() + " before sorting...");
        for (List group : groups) {
            this.setLowestComponentIdToWaiting(group);
        }
    }

    private void setLowestComponentIdToWaiting(List<IceCandidatePair> pairs) {
        IceCandidatePair pairToSet = null;
        for (IceCandidatePair pair : pairs) {
            if (pairToSet == null) {
                pairToSet = pair;
                continue;
            }
            if (pair.getComponentId() < pairToSet.getComponentId()) {
                pairToSet = pair;
                continue;
            }
            if (pair.getComponentId() != pairToSet.getComponentId() || pair.getPriority() <= pairToSet.getPriority()) continue;
            pairToSet = pair;
        }
        if (pairToSet != null) {
            pairToSet.setState(IceCandidatePairState.WAITING);
        } else {
            this.m_log.warn("No pair to set!!!");
        }
    }

    @Override
    public Queue<IceCandidatePair> getValidPairs() {
        return this.m_validPairs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLocalCandidate(IceCandidate localCandidate) {
        Collection<IceCandidate> collection = this.getLocalCandidates();
        synchronized (collection) {
            this.getLocalCandidates().add(localCandidate);
        }
    }

    @Override
    public IceCandidate getLocalCandidate(InetSocketAddress localAddress, boolean isUdp) {
        return this.getCandidate(this.getLocalCandidates(), localAddress, isUdp);
    }

    @Override
    public IceCandidate getRemoteCandidate(InetSocketAddress remoteAddress, boolean isUdp) {
        return this.getCandidate(this.m_remoteCandidates, remoteAddress, isUdp);
    }

    @Override
    public boolean hasRemoteCandidate(InetSocketAddress remoteAddress, boolean isUdp) {
        IceCandidate remoteCandidate = this.getCandidate(this.m_remoteCandidates, remoteAddress, isUdp);
        return remoteCandidate != null;
    }

    @Override
    public boolean hasRemoteCandidateInSdp(InetSocketAddress remoteAddress, boolean isUdp) {
        IceCandidate remoteCandidate = this.getCandidate(this.m_remoteSdpCandidates, remoteAddress, isUdp);
        return remoteCandidate != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IceCandidate getCandidate(Collection<IceCandidate> candidates, InetSocketAddress address, boolean isUdp) {
        Collection<IceCandidate> collection = candidates;
        synchronized (collection) {
            for (IceCandidate candidate : candidates) {
                if ((!candidate.isUdp() ? isUdp : !isUdp) || !address.equals(candidate.getSocketAddress())) continue;
                return candidate;
            }
            this.m_log.debug(address + " with transport: " + (isUdp ? "UDP" : "TCP") + " not found in " + candidates);
        }
        return null;
    }

    @Override
    public IceCandidatePair getPair(final InetSocketAddress localAddress, final InetSocketAddress remoteAddress, final boolean isUdp) {
        if (this.m_checkList == null) {
            return null;
        }
        Predicate<IceCandidatePair> pred = new Predicate<IceCandidatePair>(){

            public boolean evaluate(IceCandidatePair pair) {
                IceCandidate lc = pair.getLocalCandidate();
                IceCandidate rc = pair.getRemoteCandidate();
                return (isUdp && lc.isUdp() || !isUdp && !lc.isUdp()) && lc.getSocketAddress().equals(localAddress) && rc.getSocketAddress().equals(remoteAddress);
            }
        };
        return this.m_checkList.selectAnyPair(pred);
    }

    @Override
    public void updatePairStates(IceCandidatePair generatingPair) {
        this.m_log.debug("Updating pair states...");
        generatingPair.setState(IceCandidatePairState.SUCCEEDED);
        this.updateToWaiting(generatingPair);
    }

    @Override
    public void updateCheckListAndTimerStates() {
        if (this.allFailedOrSucceeded()) {
            this.m_log.debug("All check lists are either failed or succeeded");
            if (this.m_validPairs.isEmpty()) {
                this.m_log.debug("Setting check list state to failed...");
                this.m_checkList.setState(IceCheckListState.FAILED);
            }
            this.m_iceAgent.onUnfreezeCheckLists(this);
        }
    }

    private boolean allFailedOrSucceeded() {
        Predicate<IceCandidatePair> pred = new Predicate<IceCandidatePair>(){

            public boolean evaluate(IceCandidatePair pair) {
                return pair.getState() == IceCandidatePairState.SUCCEEDED || pair.getState() == IceCandidatePairState.FAILED;
            }
        };
        return this.m_checkList.matchesAll(pred);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValidPair(IceCandidatePair pair) {
        Queue<IceCandidatePair> queue = this.m_validPairs;
        synchronized (queue) {
            this.m_validPairs.add(pair);
        }
    }

    private void updateToWaiting(final IceCandidatePair successfulPair) {
        Closure<IceCandidatePair> closure = new Closure<IceCandidatePair>(){

            public void execute(IceCandidatePair pair) {
                if (pair.getFoundation().equals(successfulPair.getFoundation()) && pair.getState() == IceCandidatePairState.FROZEN) {
                    pair.setState(IceCandidatePairState.WAITING);
                }
            }
        };
        this.m_checkList.executeOnPairs(closure);
    }

    @Override
    public void recomputePairPriorities(boolean controlling) {
        this.m_checkList.recomputePairPriorities(controlling);
    }

    @Override
    public void addTriggeredPair(IceCandidatePair pair) {
        if (this.m_iceAgent.getIceState() == IceState.COMPLETED) {
            this.m_log.debug("Pair already nominated...not adding pair");
        } else {
            this.m_log.debug("Adding triggered pair to media stream: {}", (Object)this);
            this.m_checkList.addTriggeredPair(pair);
            this.m_checkScheduler.onPair();
        }
    }

    @Override
    public void addPair(IceCandidatePair pair) {
        if (this.m_iceAgent.getIceState() == IceState.COMPLETED) {
            this.m_log.debug("Pair already nominated...not adding pair");
        } else {
            this.m_log.debug("Adding pair to media stream: {}", (Object)this);
            this.m_checkList.addPair(pair);
        }
    }

    @Override
    public IceCheckListState getCheckListState() {
        return this.m_checkList.getState();
    }

    @Override
    public void setCheckListState(IceCheckListState state) {
        this.m_checkList.setState(state);
        if (state == IceCheckListState.COMPLETED) {
            // empty if block
        }
    }

    @Override
    public boolean hasHigherPriorityPendingPair(IceCandidatePair pair) {
        return this.m_checkList.hasHigherPriorityPendingPair(pair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNominated(IceCandidatePair pair) {
        if (pair == null) {
            throw new NullPointerException("Can't nominate null pair");
        }
        this.m_checkList.removeWaitingAndFrozenPairs(pair);
        Queue<IceCandidatePair> queue = this.m_nominatedPairs;
        synchronized (queue) {
            this.m_nominatedPairs.add(pair);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Queue<IceCandidatePair> getNominatedPairs() {
        Queue<IceCandidatePair> queue = this.m_nominatedPairs;
        synchronized (queue) {
            PriorityQueue<IceCandidatePair> pairs = new PriorityQueue<IceCandidatePair>();
            pairs.addAll(this.m_nominatedPairs);
            return pairs;
        }
    }

    public void serviceActivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
    }

    public void serviceDeactivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
    }

    public void sessionCreated(IoSession session) {
        this.m_log.debug("Setting media stream on session");
        if (this.m_closed) {
            this.m_log.info("Already closed. Closing session.");
            session.close();
            return;
        }
        session.setAttribute(IceMediaStream.class.getSimpleName(), (Object)this);
        InetSocketAddress localAddress = (InetSocketAddress)session.getLocalAddress();
        InetSocketAddress remoteAddress = (InetSocketAddress)session.getRemoteAddress();
        boolean isUdp = MinaUtils.isUdp((IoSession)session);
        IceCandidatePair pair = this.getPair(localAddress, remoteAddress, isUdp);
        if (pair == null) {
            return;
        }
        if (pair.getIoSession() == null) {
            pair.setIoSession(session);
        }
    }

    public void sessionDestroyed(IoSession session) {
    }

    @Override
    public void close() {
        this.m_closed = true;
        this.m_checkList.close();
        this.m_gatherer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IceCandidate> getLocalCandidates() {
        Collection<IceCandidate> collection = this.m_localCandidates;
        synchronized (collection) {
            return new ArrayList<IceCandidate>(this.m_localCandidates);
        }
    }

    @Override
    public InetAddress getPublicAddress() {
        return this.m_gatherer.getPublicAddress();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " controlling: " + this.m_iceAgent.isControlling();
    }

    @Override
    public IceStunUdpPeer getStunUdpPeer() {
        return this.m_udpPeer;
    }
}

