/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum IceTransportProtocol {
    TCP_SO("tcp-so"),
    TCP_ACT("tcp-act"),
    TCP_PASS("tcp-pass"),
    UDP("udp");

    private final String m_name;
    private static final Logger LOG;
    private static final Map<String, IceTransportProtocol> s_sdpToTransport;

    private IceTransportProtocol(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public static IceTransportProtocol toTransport(String sdp) {
        IceTransportProtocol type = s_sdpToTransport.get(sdp.toLowerCase(Locale.US));
        if (type == null) {
            LOG.error("No matching type for: " + sdp);
        }
        return type;
    }

    static {
        LOG = LoggerFactory.getLogger(IceTransportProtocol.class);
        s_sdpToTransport = new HashMap<String, IceTransportProtocol>();
        for (IceTransportProtocol type : IceTransportProtocol.values()) {
            s_sdpToTransport.put(type.getName(), type);
        }
    }
}

