/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collection;
import org.lastbamboo.common.ice.IceOfferAnswer;
import org.lastbamboo.common.ice.candidate.IceCandidate;
import org.lastbamboo.common.ice.candidate.IceCandidateVisitorAdapter;
import org.lastbamboo.common.ice.candidate.IceTcpRelayPassiveCandidate;
import org.lastbamboo.common.ice.sdp.IceCandidateSdpDecoderImpl;
import org.lastbamboo.common.offer.answer.OfferAnswerListener;
import org.lastbamboo.common.turn.client.TcpTurnClient;
import org.lastbamboo.common.turn.client.TurnClientListener;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.filter.codec.ProtocolCodecFactory;
import org.littleshoot.stun.stack.StunProtocolCodecFactory;
import org.littleshoot.util.CandidateProvider;
import org.littleshoot.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpTurnOfferAnswer
implements IceOfferAnswer {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final TcpTurnClient m_turnClient;
    private final boolean m_controlling;
    private ByteBuffer m_encodedCandidates;
    private final OfferAnswerListener m_offerAnswerListener;

    public TcpTurnOfferAnswer(CandidateProvider<InetSocketAddress> turnCandidateProvider, boolean controlling, OfferAnswerListener offerAnswerListener, TurnClientListener clientListener) {
        this.m_controlling = controlling;
        this.m_offerAnswerListener = offerAnswerListener;
        StunProtocolCodecFactory codecFactory = new StunProtocolCodecFactory();
        this.m_turnClient = new TcpTurnClient(clientListener, turnCandidateProvider, (ProtocolCodecFactory)codecFactory);
    }

    public void connect() throws IOException {
        this.m_turnClient.connect();
    }

    public void close() {
        this.m_turnClient.close();
    }

    public void closeTcp() {
        this.m_turnClient.close();
    }

    public void closeUdp() {
    }

    public byte[] generateAnswer() {
        return null;
    }

    public byte[] generateOffer() {
        return null;
    }

    public void processAnswer(ByteBuffer answer) {
        this.m_encodedCandidates = answer;
    }

    public void processOffer(ByteBuffer offer) {
        this.m_encodedCandidates = offer;
    }

    @Override
    public Collection<? extends IceCandidate> gatherCandidates() {
        this.m_log.info("Gathering TURN candidates");
        InetSocketAddress relatedAddress = this.m_turnClient.getServerReflexiveAddress();
        InetAddress stunServerAddress = this.m_turnClient.getStunServerAddress();
        InetSocketAddress relayAddress = this.m_turnClient.getRelayAddress();
        IceTcpRelayPassiveCandidate relayCandidate = new IceTcpRelayPassiveCandidate(relayAddress, stunServerAddress, relatedAddress.getAddress(), relatedAddress.getPort(), this.m_controlling);
        return Arrays.asList(relayCandidate);
    }

    public InetAddress getPublicAdress() {
        return this.m_turnClient.getMappedAddress().getAddress();
    }

    private void processRemoteCandidates(ByteBuffer encodedCandidates) {
        Collection<IceCandidate> remoteCandidates;
        this.m_log.info("Decoding TURN relay candidates");
        IceCandidateSdpDecoderImpl decoder = new IceCandidateSdpDecoderImpl();
        try {
            remoteCandidates = decoder.decode(encodedCandidates, false);
        }
        catch (IOException e) {
            this.m_log.warn("Could not process remote candidates", (Throwable)e);
            return;
        }
        this.m_log.info("Processing TURN relay candidates: {}", remoteCandidates);
        IceCandidateVisitorAdapter<Object> visitor = new IceCandidateVisitorAdapter<Object>(){

            @Override
            public Object visitTcpRelayPassiveCandidate(IceTcpRelayPassiveCandidate candidate) {
                TcpTurnOfferAnswer.this.m_log.info("Connecting to turn candidate");
                TcpTurnOfferAnswer.this.connectToCandidate(candidate);
                return null;
            }
        };
        for (IceCandidate candidate : remoteCandidates) {
            candidate.accept(visitor);
        }
    }

    public void useRelay() {
        this.m_log.info("Using relay");
        this.processRemoteCandidates(this.m_encodedCandidates);
    }

    private void connectToCandidate(final IceCandidate candidate) {
        if (candidate == null) {
            this.m_log.warn("Null candidate?? " + ThreadUtils.dumpStack());
            return;
        }
        Runnable threadRunner = new Runnable(){

            @Override
            public void run() {
                Socket sock = null;
                try {
                    TcpTurnOfferAnswer.this.m_log.info("Connecting to: {}", (Object)candidate);
                    sock = new Socket();
                    sock.connect(candidate.getSocketAddress(), 20000);
                    TcpTurnOfferAnswer.this.m_log.info("Connected to: {}", (Object)candidate);
                    TcpTurnOfferAnswer.this.m_offerAnswerListener.onTcpSocket(sock);
                }
                catch (IOException e) {
                    TcpTurnOfferAnswer.this.m_log.warn("Could not connect to relay?", (Throwable)e);
                }
            }
        };
        Thread connectorThread = new Thread(threadRunner, "ICE-TCP-Connect-" + candidate);
        connectorThread.setDaemon(true);
        connectorThread.start();
    }
}

