/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice.candidate;

import org.lastbamboo.common.ice.candidate.IceCandidate;

public class IceCandidatePairPriorityCalculator {
    private IceCandidatePairPriorityCalculator() {
    }

    public static long calculatePriority(IceCandidate localCandidate, IceCandidate remoteCandidate) {
        long D;
        long G;
        if (localCandidate.isControlling()) {
            G = localCandidate.getPriority();
            D = remoteCandidate.getPriority();
        } else {
            G = remoteCandidate.getPriority();
            D = localCandidate.getPriority();
        }
        long A = (long)(Math.pow(2.0, 32.0) * (double)Math.min(G, D));
        long B = 2L * Math.max(G, D);
        int C = G > D ? 1 : 0;
        long pairPriority = A + B + (long)C;
        return pairPriority;
    }
}

