/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice.candidate;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.lastbamboo.common.ice.IceStunChecker;
import org.lastbamboo.common.ice.IceStunCheckerFactory;
import org.lastbamboo.common.ice.candidate.IceCandidate;
import org.lastbamboo.common.ice.candidate.IceCandidatePair;
import org.lastbamboo.common.ice.candidate.IceCandidatePairPriorityCalculator;
import org.lastbamboo.common.ice.candidate.IceCandidatePairState;
import org.lastbamboo.common.ice.candidate.IceCandidatePairVisitor;
import org.lastbamboo.common.ice.candidate.IceTcpActiveCandidate;
import org.lastbamboo.common.ice.transport.IceConnector;
import org.lastbamboo.common.turn.client.TurnStunMessageMapper;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.stun.stack.message.BindingRequest;
import org.littleshoot.stun.stack.message.CanceledStunMessage;
import org.littleshoot.stun.stack.message.ConnectErrorStunMessage;
import org.littleshoot.stun.stack.message.StunMessage;
import org.littleshoot.util.NetworkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IceUdpCandidatePair
implements IceCandidatePair {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final IceCandidate m_localCandidate;
    private final IceCandidate m_remoteCandidate;
    private volatile long m_priority;
    private volatile IceCandidatePairState m_state;
    private final String m_foundation;
    private final int m_componentId;
    private volatile boolean m_nominated = false;
    private volatile IceStunChecker m_currentStunChecker;
    private volatile boolean m_useCandidate = false;
    protected volatile IoSession m_ioSession;
    private final IceStunCheckerFactory m_stunCheckerFactory;
    private final IceConnector m_iceConnector;
    private boolean m_turnPair;
    private volatile boolean m_transactionCanceled = false;
    private boolean m_nominateOnSuccess;

    public IceUdpCandidatePair(IceCandidate localCandidate, IceCandidate remoteCandidate, IceStunCheckerFactory stunCheckerFactory, IceConnector iceConnector) {
        this(localCandidate, remoteCandidate, IceCandidatePairPriorityCalculator.calculatePriority(localCandidate, remoteCandidate), null, stunCheckerFactory, iceConnector);
    }

    public IceUdpCandidatePair(IceCandidate localCandidate, IceCandidate remoteCandidate, IoSession ioSession, IceStunCheckerFactory stunCheckerFactory) {
        this(localCandidate, remoteCandidate, IceCandidatePairPriorityCalculator.calculatePriority(localCandidate, remoteCandidate), ioSession, stunCheckerFactory, null);
    }

    private IceUdpCandidatePair(IceCandidate localCandidate, IceCandidate remoteCandidate, long priority, IoSession ioSession, IceStunCheckerFactory stunCheckerFactory, IceConnector iceConnector) {
        this.m_localCandidate = localCandidate;
        this.m_remoteCandidate = remoteCandidate;
        this.m_ioSession = ioSession;
        this.m_componentId = localCandidate.getComponentId();
        this.m_priority = priority;
        this.m_state = IceCandidatePairState.FROZEN;
        this.m_foundation = String.valueOf(localCandidate.getFoundation()) + String.valueOf(remoteCandidate.getFoundation());
        this.m_stunCheckerFactory = stunCheckerFactory;
        this.m_iceConnector = iceConnector;
    }

    @Override
    public StunMessage check(BindingRequest request, long rto) {
        this.setState(IceCandidatePairState.IN_PROGRESS);
        InetSocketAddress remoteAddress = this.m_remoteCandidate.getSocketAddress();
        if (this.m_ioSession == null) {
            if (!(this.m_localCandidate instanceof IceTcpActiveCandidate) && !this.m_localCandidate.isUdp()) {
                this.m_log.error("Connecting with non-active TCP candidate: {}", (Object)this.m_localCandidate);
                throw new IllegalStateException("Local candidate is not active: " + this.m_localCandidate);
            }
            InetSocketAddress localAddress = this.m_localCandidate.getSocketAddress();
            this.m_ioSession = this.m_iceConnector.connect(localAddress, remoteAddress);
        }
        if (this.m_ioSession == null) {
            this.m_log.debug("Could not connect to the remote host: {}", (Object)this.m_remoteCandidate.getSocketAddress());
            return new ConnectErrorStunMessage();
        }
        TurnStunMessageMapper mapper = (TurnStunMessageMapper)this.m_ioSession.getAttribute("REMOTE_ADDRESS_MAP");
        if (mapper != null) {
            this.m_log.debug("Mapping Binding Request to the REMOTE-ADDRESS for this pair for use in the Send Indication");
            mapper.mapMessage((StunMessage)request, remoteAddress);
            this.m_turnPair = true;
        }
        this.m_log.debug("Creating new STUN checker...");
        this.m_currentStunChecker = this.m_stunCheckerFactory.newChecker(this.m_ioSession);
        if (!this.m_transactionCanceled) {
            this.m_log.debug("Writing request...");
            return this.m_currentStunChecker.write(request, rto);
        }
        this.m_log.debug("The transaction was canceled...");
        this.m_transactionCanceled = false;
        return new CanceledStunMessage();
    }

    @Override
    public void useCandidate() {
        this.m_useCandidate = true;
    }

    @Override
    public boolean useCandidateSet() {
        return this.m_useCandidate;
    }

    @Override
    public void cancelStunTransaction() {
        this.m_transactionCanceled = true;
        if (this.m_currentStunChecker != null) {
            this.m_currentStunChecker.cancelTransaction();
            this.m_transactionCanceled = false;
        }
    }

    @Override
    public void recomputePriority() {
        this.m_priority = IceCandidatePairPriorityCalculator.calculatePriority(this.m_localCandidate, this.m_remoteCandidate);
    }

    @Override
    public IceCandidate getLocalCandidate() {
        return this.m_localCandidate;
    }

    @Override
    public IceCandidate getRemoteCandidate() {
        return this.m_remoteCandidate;
    }

    @Override
    public long getPriority() {
        return this.m_priority;
    }

    @Override
    public IceCandidatePairState getState() {
        return this.m_state;
    }

    @Override
    public String getFoundation() {
        return this.m_foundation;
    }

    @Override
    public void setState(IceCandidatePairState state) {
        if (this.m_nominated) {
            this.m_log.debug("Trying to change the state of a nominated pair to: {}", (Object)state);
        }
        this.m_state = state;
        if (state == IceCandidatePairState.FAILED) {
            this.m_log.debug("Setting state to failed, closing checker");
            this.close();
        }
    }

    @Override
    public void setIoSession(IoSession session) {
        if (this.m_ioSession != null) {
            this.m_log.warn("Ignoring set session because it already exists!!");
            return;
        }
        this.m_ioSession = session;
    }

    @Override
    public int getComponentId() {
        return this.m_componentId;
    }

    @Override
    public void nominate() {
        this.m_nominated = true;
    }

    @Override
    public boolean isNominated() {
        return this.m_nominated;
    }

    @Override
    public boolean isTcp() {
        return false;
    }

    @Override
    public void nominateOnSuccess() {
        this.m_nominateOnSuccess = true;
    }

    @Override
    public boolean isNominateOnSuccess() {
        return this.m_nominateOnSuccess;
    }

    @Override
    public void close() {
        this.m_log.debug("Closing pair...");
        if (this.m_currentStunChecker != null) {
            this.m_currentStunChecker.close();
        }
    }

    @Override
    public IoSession getIoSession() {
        return this.m_ioSession;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("local:               ");
        sb.append(this.m_localCandidate);
        sb.append("\n");
        sb.append("remote:              ");
        sb.append(this.m_remoteCandidate);
        sb.append("\n");
        sb.append("state:               ");
        sb.append((Object)this.m_state);
        sb.append("\n");
        sb.append("use-candidate:       ");
        sb.append(this.m_useCandidate);
        sb.append("\n");
        sb.append("nominated:           ");
        sb.append(this.m_nominated);
        return sb.toString();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.m_componentId;
        result = 31 * result + (this.m_foundation == null ? 0 : this.m_foundation.hashCode());
        result = 31 * result + (this.m_localCandidate == null ? 0 : this.m_localCandidate.hashCode());
        result = 31 * result + (int)(this.m_priority ^ this.m_priority >>> 32);
        result = 31 * result + (this.m_remoteCandidate == null ? 0 : this.m_remoteCandidate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IceUdpCandidatePair other = (IceUdpCandidatePair)obj;
        if (this.m_componentId != other.m_componentId) {
            return false;
        }
        if (this.m_foundation == null ? other.m_foundation != null : !this.m_foundation.equals(other.m_foundation)) {
            return false;
        }
        if (this.m_localCandidate == null ? other.m_localCandidate != null : !this.m_localCandidate.equals(other.m_localCandidate)) {
            return false;
        }
        if (this.m_priority != other.m_priority) {
            return false;
        }
        return !(this.m_remoteCandidate == null ? other.m_remoteCandidate != null : !this.m_remoteCandidate.equals(other.m_remoteCandidate));
    }

    @Override
    public int compareTo(IceCandidatePair other) {
        Long priority2;
        Long priority1 = this.m_priority;
        int priorityComparison = priority1.compareTo(priority2 = Long.valueOf(other.getPriority()));
        if (priorityComparison != 0) {
            return -priorityComparison;
        }
        if (this.equals(other)) {
            return 0;
        }
        if (NetworkUtils.isPublicAddress((InetAddress)this.m_remoteCandidate.getSocketAddress().getAddress())) {
            return -1;
        }
        if (NetworkUtils.isPublicAddress((InetAddress)other.getRemoteCandidate().getSocketAddress().getAddress())) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isTurnPair() {
        return this.m_turnPair;
    }

    @Override
    public <T> T accept(IceCandidatePairVisitor<T> visitor) {
        return visitor.visitUdpIceCandidatePair(this);
    }
}

