/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice.candidate;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.lastbamboo.common.ice.IcePriorityCalculator;
import org.lastbamboo.common.ice.IceTransportProtocol;
import org.lastbamboo.common.ice.candidate.AbstractIceCandidate;
import org.lastbamboo.common.ice.candidate.IceCandidate;
import org.lastbamboo.common.ice.candidate.IceCandidateType;
import org.lastbamboo.common.ice.candidate.IceCandidateVisitor;
import org.lastbamboo.common.ice.candidate.IceFoundationCalculator;

public class IceUdpServerReflexiveCandidate
extends AbstractIceCandidate {
    public IceUdpServerReflexiveCandidate(InetSocketAddress serverReflexiveAddress, IceCandidate baseCandidate, InetAddress stunServerAddress, boolean controlling) {
        super(serverReflexiveAddress, IceFoundationCalculator.calculateFoundation(IceCandidateType.SERVER_REFLEXIVE, baseCandidate.getSocketAddress().getAddress(), IceTransportProtocol.UDP, stunServerAddress), IceCandidateType.SERVER_REFLEXIVE, IceTransportProtocol.UDP, IcePriorityCalculator.calculatePriority(IceCandidateType.SERVER_REFLEXIVE, IceTransportProtocol.UDP), controlling, 1, baseCandidate, baseCandidate.getSocketAddress().getAddress(), baseCandidate.getSocketAddress().getPort());
    }

    public IceUdpServerReflexiveCandidate(InetSocketAddress serverReflexiveAddress, String foundation, InetAddress relatedAddress, int relatedPort, boolean controlling, long priority, int componentId) {
        super(serverReflexiveAddress, foundation, IceCandidateType.SERVER_REFLEXIVE, IceTransportProtocol.UDP, priority, controlling, componentId, null, relatedAddress, relatedPort);
    }

    @Override
    public <T> T accept(IceCandidateVisitor<T> visitor) {
        return visitor.visitUdpServerReflexiveCandidate(this);
    }
}

