/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice.candidate;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.lastbamboo.common.ice.candidate.IceCandidate;
import org.lastbamboo.common.ice.candidate.IceCandidateGatherer;
import org.lastbamboo.common.ice.candidate.IceUdpHostCandidate;
import org.lastbamboo.common.ice.candidate.IceUdpServerReflexiveCandidate;
import org.lastbamboo.common.offer.answer.IceMediaStreamDesc;
import org.lastbamboo.common.stun.client.StunClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpIceCandidateGatherer
implements IceCandidateGatherer {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final StunClient m_iceUdpStunPeer;
    private final boolean m_controlling;
    private final IceMediaStreamDesc m_desc;
    private InetSocketAddress m_udpServerReflexiveAddress;

    public UdpIceCandidateGatherer(StunClient udpStunClient, boolean controlling, IceMediaStreamDesc desc) {
        if (desc.isUdp() && udpStunClient == null) {
            throw new IllegalArgumentException("No UDP client with UDP active");
        }
        this.m_iceUdpStunPeer = udpStunClient;
        this.m_controlling = controlling;
        this.m_desc = desc;
    }

    @Override
    public Collection<IceCandidate> gatherCandidates() {
        ArrayList<IceCandidate> candidates = new ArrayList<IceCandidate>();
        if (this.m_desc.isUdp()) {
            Collection<IceCandidate> udpCandidates = this.createUdpCandidates(this.m_iceUdpStunPeer);
            this.eliminateRedundantCandidates(udpCandidates);
            candidates.addAll(udpCandidates);
        }
        return candidates;
    }

    private void eliminateRedundantCandidates(Collection<IceCandidate> candidates) {
        HashMap<InetSocketAddress, IceCandidate> addressesToCandidates = new HashMap<InetSocketAddress, IceCandidate>();
        Iterator<IceCandidate> iter = candidates.iterator();
        while (iter.hasNext()) {
            IceCandidate candidate = iter.next();
            this.m_log.debug("Checking: {}", (Object)candidate);
            InetSocketAddress address = candidate.getSocketAddress();
            if (addressesToCandidates.containsKey(address)) {
                IceCandidate existingCandidate = (IceCandidate)addressesToCandidates.get(address);
                IceCandidate base = existingCandidate.getBaseCandidate();
                if (!base.equals(candidate.getBaseCandidate())) continue;
                this.m_log.debug("Removing redundant candidate!!!!");
                iter.remove();
                continue;
            }
            addressesToCandidates.put(address, candidate);
        }
    }

    private Collection<IceCandidate> createUdpCandidates(StunClient client) {
        ArrayList<IceCandidate> candidates = new ArrayList<IceCandidate>();
        InetAddress stunServerAddress = client.getStunServerAddress();
        InetSocketAddress hostAddress = client.getHostAddress();
        IceUdpHostCandidate hostCandidate = new IceUdpHostCandidate(hostAddress, this.m_controlling);
        candidates.add(hostCandidate);
        try {
            this.m_udpServerReflexiveAddress = client.getServerReflexiveAddress();
            this.m_log.info("Got server reflexive: {}", (Object)this.m_udpServerReflexiveAddress);
        }
        catch (IOException e) {
            this.m_log.error("Could not get UDP server reflexive candidate", (Throwable)e);
            return candidates;
        }
        IceUdpServerReflexiveCandidate serverReflexiveCandidate = new IceUdpServerReflexiveCandidate(this.m_udpServerReflexiveAddress, hostCandidate, stunServerAddress, this.m_controlling);
        candidates.add(serverReflexiveCandidate);
        return candidates;
    }

    @Override
    public InetAddress getPublicAddress() {
        if (this.m_udpServerReflexiveAddress == null) {
            return null;
        }
        return this.m_udpServerReflexiveAddress.getAddress();
    }

    @Override
    public void close() {
        if (this.m_iceUdpStunPeer != null) {
            this.m_iceUdpStunPeer.close();
        }
    }
}

