/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice.sdp;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Vector;
import org.apache.commons.lang.ObjectUtils;
import org.lastbamboo.common.ice.candidate.IceCandidate;
import org.lastbamboo.common.ice.candidate.IceCandidateVisitor;
import org.lastbamboo.common.ice.candidate.IceTcpActiveCandidate;
import org.lastbamboo.common.ice.candidate.IceTcpHostPassiveCandidate;
import org.lastbamboo.common.ice.candidate.IceTcpPeerReflexiveCandidate;
import org.lastbamboo.common.ice.candidate.IceTcpRelayPassiveCandidate;
import org.lastbamboo.common.ice.candidate.IceTcpServerReflexiveSoCandidate;
import org.lastbamboo.common.ice.candidate.IceUdpHostCandidate;
import org.lastbamboo.common.ice.candidate.IceUdpPeerReflexiveCandidate;
import org.lastbamboo.common.ice.candidate.IceUdpRelayCandidate;
import org.lastbamboo.common.ice.candidate.IceUdpServerReflexiveCandidate;
import org.lastbamboo.common.sdp.api.Attribute;
import org.lastbamboo.common.sdp.api.Connection;
import org.lastbamboo.common.sdp.api.MediaDescription;
import org.lastbamboo.common.sdp.api.Origin;
import org.lastbamboo.common.sdp.api.SdpException;
import org.lastbamboo.common.sdp.api.SdpFactory;
import org.lastbamboo.common.sdp.api.SessionDescription;
import org.lastbamboo.common.sdp.api.SessionName;
import org.lastbamboo.common.sdp.api.TimeDescription;
import org.littleshoot.util.NetworkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IceCandidateSdpEncoder
implements IceCandidateVisitor<ObjectUtils.Null> {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final SdpFactory m_sdpFactory;
    private final SessionDescription m_sessionDescription;
    private final Vector<Attribute> m_candidates;
    private final String m_mimeContentType;
    private final String m_mimeContentSubtype;
    private final IceCandidate[] m_defaultCandidates = new IceCandidate[5];

    public IceCandidateSdpEncoder(String mimeContentType, String mimeContentSubtype) {
        this.m_mimeContentType = mimeContentType;
        this.m_mimeContentSubtype = mimeContentSubtype;
        this.m_sdpFactory = new SdpFactory();
        InetAddress address = this.getAddress();
        String addrType = address instanceof Inet6Address ? "IP6" : "IP4";
        this.m_candidates = new Vector();
        try {
            Origin o = this.m_sdpFactory.createOrigin("-", 0L, 0L, "IN", addrType, address.getHostAddress());
            SessionName s = this.m_sdpFactory.createSessionName("-");
            TimeDescription t = this.m_sdpFactory.createTimeDescription();
            Vector<TimeDescription> timeDescriptions = new Vector<TimeDescription>();
            timeDescriptions.add(t);
            this.m_sessionDescription = this.createSessionDescription();
            this.m_sessionDescription.setVersion(this.m_sdpFactory.createVersion(0));
            this.m_sessionDescription.setOrigin(o);
            this.m_sessionDescription.setSessionName(s);
            this.m_sessionDescription.setTimeDescriptions(timeDescriptions);
        }
        catch (SdpException e) {
            this.m_log.error("Could not create SDP", (Throwable)e);
            throw new IllegalArgumentException("Could not create SDP", e);
        }
    }

    public byte[] getSdp() {
        return this.m_sessionDescription.toBytes();
    }

    private InetAddress getAddress() {
        try {
            return NetworkUtils.getLocalHost();
        }
        catch (UnknownHostException e) {
            this.m_log.error("Could not resolve host", (Throwable)e);
            throw new RuntimeException("Could not resolve host", e);
        }
    }

    private SessionDescription createSessionDescription() {
        try {
            return this.m_sdpFactory.createSessionDescription();
        }
        catch (SdpException e) {
            this.m_log.error("Could not create SDP", (Throwable)e);
            throw new IllegalArgumentException("Could not create SDP", e);
        }
    }

    @Override
    public void visitCandidates(Collection<IceCandidate> candidates) {
        this.m_log.info("Visiting candidates: {}", candidates);
        for (IceCandidate candidate : candidates) {
            candidate.accept(this);
        }
        try {
            IceCandidate defaultCandidate = null;
            for (IceCandidate candidate : this.m_defaultCandidates) {
                if (candidate == null) continue;
                defaultCandidate = candidate;
            }
            if (defaultCandidate == null) {
                this.m_log.error("No default candidate from: {}", candidates);
                return;
            }
            MediaDescription md = this.createMessageMediaDesc(defaultCandidate);
            md.setAttributes(this.m_candidates);
            this.m_log.debug("Adding media description");
            Vector<MediaDescription> mediaDescriptions = new Vector<MediaDescription>();
            mediaDescriptions.add(md);
            this.m_sessionDescription.setMediaDescriptions(mediaDescriptions);
        }
        catch (SdpException e) {
            this.m_log.error("Could not add the media descriptions", (Throwable)e);
        }
    }

    @Override
    public ObjectUtils.Null visitTcpHostPassiveCandidate(IceTcpHostPassiveCandidate candidate) {
        this.addAttribute(candidate);
        this.m_defaultCandidates[1] = candidate;
        return ObjectUtils.NULL;
    }

    @Override
    public ObjectUtils.Null visitTcpPeerReflexiveCandidate(IceTcpPeerReflexiveCandidate candidate) {
        this.addAttributeWithRelated(candidate);
        return ObjectUtils.NULL;
    }

    @Override
    public ObjectUtils.Null visitTcpRelayPassiveCandidate(IceTcpRelayPassiveCandidate candidate) {
        this.addAttributeWithRelated(candidate);
        this.m_defaultCandidates[3] = candidate;
        return ObjectUtils.NULL;
    }

    @Override
    public ObjectUtils.Null visitTcpServerReflexiveSoCandidate(IceTcpServerReflexiveSoCandidate candidate) {
        this.addAttributeWithRelated(candidate);
        return ObjectUtils.NULL;
    }

    @Override
    public ObjectUtils.Null visitTcpActiveCandidate(IceTcpActiveCandidate candidate) {
        this.addAttribute(candidate, 9);
        this.m_defaultCandidates[4] = candidate;
        return ObjectUtils.NULL;
    }

    @Override
    public ObjectUtils.Null visitUdpHostCandidate(IceUdpHostCandidate candidate) {
        this.addAttribute(candidate);
        this.m_defaultCandidates[2] = candidate;
        return ObjectUtils.NULL;
    }

    @Override
    public ObjectUtils.Null visitUdpPeerReflexiveCandidate(IceUdpPeerReflexiveCandidate candidate) {
        this.addAttributeWithRelated(candidate);
        return ObjectUtils.NULL;
    }

    @Override
    public ObjectUtils.Null visitUdpRelayCandidate(IceUdpRelayCandidate candidate) {
        this.addAttributeWithRelated(candidate);
        return ObjectUtils.NULL;
    }

    @Override
    public ObjectUtils.Null visitUdpServerReflexiveCandidate(IceUdpServerReflexiveCandidate candidate) {
        this.m_log.info("Visiting UDP server reflexive: {}", (Object)candidate);
        this.addAttributeWithRelated(candidate);
        this.m_defaultCandidates[0] = candidate;
        return ObjectUtils.NULL;
    }

    private MediaDescription createMessageMediaDesc(IceCandidate candidate) throws SdpException {
        InetSocketAddress socketAddress = candidate.getSocketAddress();
        String protocol = candidate.getTransport().getName();
        MediaDescription md = this.m_sdpFactory.createMediaDescription(this.m_mimeContentType, socketAddress.getPort(), 1, protocol, new String[]{this.m_mimeContentSubtype});
        Connection conn = this.m_sdpFactory.createConnection("IN", "IP4", socketAddress.getAddress().getHostAddress());
        md.setConnection(conn);
        return md;
    }

    private StringBuilder createBaseCandidateAttribute(IceCandidate candidate, int port) {
        String space = " ";
        StringBuilder sb = new StringBuilder();
        sb.append(candidate.getFoundation());
        sb.append(" ");
        sb.append(candidate.getComponentId());
        sb.append(" ");
        sb.append(candidate.getTransport().getName());
        sb.append(" ");
        sb.append(candidate.getPriority());
        sb.append(" ");
        InetSocketAddress sa = candidate.getSocketAddress();
        InetAddress ia = sa.getAddress();
        sb.append(ia.getHostAddress());
        sb.append(" ");
        sb.append(port);
        sb.append(" ");
        sb.append("typ");
        sb.append(" ");
        sb.append(candidate.getType().toSdp());
        return sb;
    }

    private void addAttribute(IceCandidate candidate) {
        this.addAttribute(candidate, candidate.getSocketAddress().getPort());
    }

    private void addAttribute(IceCandidate candidate, int port) {
        StringBuilder sb = this.createBaseCandidateAttribute(candidate, port);
        Attribute attribute = this.m_sdpFactory.createAttribute("candidate", sb.toString());
        this.m_candidates.add(attribute);
    }

    private void addAttributeWithRelated(IceCandidate candidate) {
        int port = candidate.getSocketAddress().getPort();
        StringBuilder sb = this.createBaseCandidateAttribute(candidate, port);
        String space = " ";
        sb.append(" ");
        sb.append("raddr");
        sb.append(" ");
        sb.append(candidate.getRelatedAddress().getHostAddress());
        sb.append(" ");
        sb.append("rport");
        sb.append(" ");
        sb.append(candidate.getRelatedPort());
        Attribute attribute = this.m_sdpFactory.createAttribute("candidate", sb.toString());
        this.m_candidates.add(attribute);
    }
}

