/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice.transport;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.lang.SystemUtils;
import org.lastbamboo.common.ice.transport.IceConnector;
import org.lastbamboo.common.tcp.frame.TcpFrame;
import org.lastbamboo.common.tcp.frame.TcpFrameCodecFactory;
import org.lastbamboo.common.tcp.frame.TcpFrameIoHandler;
import org.littleshoot.mina.common.ConnectFuture;
import org.littleshoot.mina.common.ExecutorThreadModel;
import org.littleshoot.mina.common.IoFilter;
import org.littleshoot.mina.common.IoFuture;
import org.littleshoot.mina.common.IoFutureListener;
import org.littleshoot.mina.common.IoHandler;
import org.littleshoot.mina.common.IoServiceListener;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.common.RuntimeIOException;
import org.littleshoot.mina.common.ThreadModel;
import org.littleshoot.mina.filter.codec.ProtocolCodecFactory;
import org.littleshoot.mina.filter.codec.ProtocolCodecFilter;
import org.littleshoot.mina.transport.socket.nio.SocketConnector;
import org.littleshoot.mina.transport.socket.nio.SocketConnectorConfig;
import org.littleshoot.stun.stack.StunDemuxableProtocolCodecFactory;
import org.littleshoot.stun.stack.StunIoHandler;
import org.littleshoot.stun.stack.message.StunMessage;
import org.littleshoot.stun.stack.message.StunMessageVisitorFactory;
import org.littleshoot.util.mina.DemuxableProtocolCodecFactory;
import org.littleshoot.util.mina.DemuxingIoHandler;
import org.littleshoot.util.mina.DemuxingProtocolCodecFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IceTcpConnector
implements IceConnector {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final boolean m_controlling;
    private final DemuxingIoHandler<StunMessage, TcpFrame> m_demuxingIoHandler;
    private final Collection<IoServiceListener> m_serviceListeners = new LinkedList<IoServiceListener>();

    public IceTcpConnector(StunMessageVisitorFactory messageVisitorFactory, boolean controlling) {
        this.m_controlling = controlling;
        StunIoHandler stunIoHandler = new StunIoHandler(messageVisitorFactory);
        TcpFrameIoHandler streamIoHandler = new TcpFrameIoHandler();
        this.m_demuxingIoHandler = new DemuxingIoHandler(StunMessage.class, (IoHandler)stunIoHandler, TcpFrame.class, (IoHandler)streamIoHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoSession connect(InetSocketAddress localAddress, InetSocketAddress remoteAddress) {
        this.m_log.debug("Creating TCP connection from " + localAddress + " to " + remoteAddress);
        SocketConnector connector = new SocketConnector();
        Collection<IoServiceListener> collection = this.m_serviceListeners;
        synchronized (collection) {
            for (IoServiceListener listener : this.m_serviceListeners) {
                connector.addListener(listener);
            }
        }
        SocketConnectorConfig cfg = connector.getDefaultConfig();
        if (SystemUtils.IS_OS_WINDOWS_VISTA) {
            cfg.getSessionConfig().setKeepAlive(false);
        }
        cfg.getSessionConfig().setReuseAddress(true);
        ExecutorThreadModel threadModel = ExecutorThreadModel.getInstance((String)(this.getClass().getSimpleName() + (this.m_controlling ? "-Controlling-" : "-Not-Controlling-") + this.hashCode()));
        cfg.setThreadModel((ThreadModel)threadModel);
        connector.setDefaultConfig(cfg);
        StunDemuxableProtocolCodecFactory stunCodecFactory = new StunDemuxableProtocolCodecFactory();
        TcpFrameCodecFactory tcpFramingCodecFactory = new TcpFrameCodecFactory();
        DemuxingProtocolCodecFactory demuxingCodecFactory = new DemuxingProtocolCodecFactory((DemuxableProtocolCodecFactory)stunCodecFactory, (DemuxableProtocolCodecFactory)tcpFramingCodecFactory);
        ProtocolCodecFilter demuxingFilter = new ProtocolCodecFilter((ProtocolCodecFactory)demuxingCodecFactory);
        connector.getFilterChain().addLast("demuxingFilter", (IoFilter)demuxingFilter);
        this.m_log.debug("Establishing TCP connection to: {}", (Object)remoteAddress);
        InetAddress address = remoteAddress.getAddress();
        int connectTimeout = address.isSiteLocalAddress() ? 6000 : 10000;
        this.m_log.debug("Connecting with timeout: {}", (Object)connectTimeout);
        ConnectFuture cf = connector.connect((SocketAddress)remoteAddress, this.m_demuxingIoHandler);
        IoFutureListener futureListener = new IoFutureListener(){

            public void operationComplete(IoFuture future) {
                IceTcpConnector.this.m_log.debug("Got future: {}", (Object)future);
                IceTcpConnector.this.m_log.debug("Ready: {}", (Object)future.isReady());
            }
        };
        cf.addListener(futureListener);
        cf.join((long)connectTimeout);
        this.m_log.debug("Successfully joined...");
        try {
            IoSession session = cf.getSession();
            if (session == null) {
                this.m_log.debug("Session is null!!");
                return null;
            }
            this.m_log.debug("TCP STUN checker connected on: {}", (Object)session);
            return session;
        }
        catch (RuntimeIOException e) {
            this.m_log.debug("Could not connect to host: {}", (Object)remoteAddress);
            this.m_log.debug("Reason for no connection: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public void addIoServiceListener(IoServiceListener serviceListener) {
        this.m_serviceListeners.add(serviceListener);
    }
}

