/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice.transport;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import org.lastbamboo.common.ice.transport.IceConnector;
import org.littleshoot.mina.common.ConnectFuture;
import org.littleshoot.mina.common.ExecutorThreadModel;
import org.littleshoot.mina.common.IoFilter;
import org.littleshoot.mina.common.IoHandler;
import org.littleshoot.mina.common.IoService;
import org.littleshoot.mina.common.IoServiceConfig;
import org.littleshoot.mina.common.IoServiceListener;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.common.RuntimeIOException;
import org.littleshoot.mina.common.ThreadModel;
import org.littleshoot.mina.filter.codec.ProtocolCodecFactory;
import org.littleshoot.mina.filter.codec.ProtocolCodecFilter;
import org.littleshoot.mina.transport.socket.nio.DatagramConnector;
import org.littleshoot.mina.transport.socket.nio.DatagramConnectorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IceUdpConnector
implements IceConnector,
IoServiceListener {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final ProtocolCodecFactory m_demuxingCodecFactory;
    private final IoHandler m_demuxingIoHandler;
    private final boolean m_controlling;
    private final Collection<IoServiceListener> m_serviceListeners = new ArrayList<IoServiceListener>();
    private final DatagramConnector m_connector;

    public IceUdpConnector(ProtocolCodecFactory protocolCodecFactory, IoHandler demuxingIoHandler, boolean controlling) {
        this.m_demuxingCodecFactory = protocolCodecFactory;
        this.m_demuxingIoHandler = demuxingIoHandler;
        this.m_controlling = controlling;
        this.m_connector = new DatagramConnector();
        DatagramConnectorConfig cfg = this.m_connector.getDefaultConfig();
        cfg.getSessionConfig().setReuseAddress(true);
        ExecutorThreadModel threadModel = ExecutorThreadModel.getInstance((String)(this.getClass().getSimpleName() + (this.m_controlling ? "-Controlling" : "-Not-Controlling")));
        ProtocolCodecFilter demuxingFilter = new ProtocolCodecFilter(this.m_demuxingCodecFactory);
        cfg.setThreadModel((ThreadModel)threadModel);
        this.m_log.debug("Setting demuxFilter...");
        this.m_connector.getFilterChain().addLast("demuxFilter", (IoFilter)demuxingFilter);
        this.m_connector.addListener((IoServiceListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoSession connect(InetSocketAddress localAddress, InetSocketAddress remoteAddress) {
        Collection<IoServiceListener> collection = this.m_serviceListeners;
        synchronized (collection) {
            for (IoServiceListener listener : this.m_serviceListeners) {
                this.m_connector.addListener(listener);
            }
        }
        this.m_log.debug("Connecting from " + localAddress + " to " + remoteAddress);
        ConnectFuture cf = this.m_connector.connect((SocketAddress)remoteAddress, (SocketAddress)localAddress, this.m_demuxingIoHandler);
        cf.join();
        try {
            IoSession session = cf.getSession();
            if (session == null) {
                this.m_log.error("Could not create session from " + localAddress + " to " + remoteAddress);
                throw new RuntimeIOException("Could not create session");
            }
            if (!session.isConnected()) {
                throw new RuntimeIOException("Not connected");
            }
            return session;
        }
        catch (RuntimeIOException e) {
            this.m_log.error("Could not create session from " + localAddress + " to " + remoteAddress + " -- look at the CAUSE!!!", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void addIoServiceListener(IoServiceListener serviceListener) {
        this.m_serviceListeners.add(serviceListener);
    }

    public void serviceActivated(IoService arg0, SocketAddress arg1, IoHandler arg2, IoServiceConfig arg3) {
    }

    public void serviceDeactivated(IoService arg0, SocketAddress arg1, IoHandler arg2, IoServiceConfig arg3) {
    }

    public void sessionCreated(IoSession arg0) {
    }

    public void sessionDestroyed(IoSession session) {
        this.m_log.info("Got session closed: {}", (Object)session);
        try {
            this.m_connector.getFilterChain().clear();
        }
        catch (Exception e) {
            this.m_log.warn("Exception clearing filter chaing!!", (Throwable)e);
        }
    }
}

