/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.ice.transport;

import java.net.InetSocketAddress;
import org.apache.commons.id.uuid.UUID;
import org.lastbamboo.common.ice.transport.AbstractIceStunChecker;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.stun.stack.message.BindingRequest;
import org.littleshoot.stun.stack.message.CanceledStunMessage;
import org.littleshoot.stun.stack.message.NullStunMessage;
import org.littleshoot.stun.stack.message.StunMessage;
import org.littleshoot.stun.stack.transaction.StunTransactionListener;
import org.littleshoot.stun.stack.transaction.StunTransactionTracker;
import org.littleshoot.util.RuntimeIoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IceUdpStunChecker
extends AbstractIceStunChecker {
    private static final Logger LOG = LoggerFactory.getLogger(IceUdpStunChecker.class);

    public IceUdpStunChecker(IoSession session, StunTransactionTracker<StunMessage> transactionTracker) {
        super(session, transactionTracker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StunMessage writeInternal(BindingRequest bindingRequest, long rto) {
        if (this.m_transactionCanceled) {
            return new CanceledStunMessage();
        }
        if (this.m_writeCallsForChecker > 1) {
            throw new RuntimeIoException("Too many write calls: " + this.m_writeCallsForChecker);
        }
        if (bindingRequest == null) {
            throw new NullPointerException("Null Binding Request");
        }
        UUID id = bindingRequest.getTransactionId();
        InetSocketAddress localAddress = (InetSocketAddress)this.m_ioSession.getLocalAddress();
        InetSocketAddress remoteAddress = (InetSocketAddress)this.m_ioSession.getRemoteAddress();
        this.m_transactionTracker.addTransaction((StunMessage)bindingRequest, (StunTransactionListener)this, localAddress, remoteAddress);
        Object object = this.m_requestLock;
        synchronized (object) {
            long waitTime = 0L;
            for (int requests = 0; !this.m_idsToResponses.containsKey(id) && requests < 7 && !this.m_transactionCanceled; ++requests) {
                this.waitIfNoResponse(bindingRequest, waitTime);
                if (this.m_transactionCanceled) break;
                if (this.m_ioSession.isConnected()) {
                    LOG.info("Writing binding request: {} on {}", (Object)bindingRequest, (Object)this.m_ioSession);
                    this.m_ioSession.write((Object)bindingRequest);
                }
                waitTime = 2L * waitTime + rto;
            }
            if (!this.m_transactionCanceled) {
                this.waitIfNoResponse(bindingRequest, 1600L);
            }
            if (this.m_idsToResponses.containsKey(id)) {
                StunMessage response = (StunMessage)this.m_idsToResponses.remove(id);
                LOG.debug("Received STUN response: {}", (Object)response);
                return response;
            }
            if (this.m_transactionCanceled || this.m_closed || this.m_ioSession.isClosing()) {
                LOG.debug("The transaction was canceled!");
                return new CanceledStunMessage();
            }
            LOG.debug("Did not get response on: {}", (Object)this.m_ioSession);
            return new NullStunMessage();
        }
    }
}

