/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.mina.common;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.littleshoot.mina.common.IoFilterChain;
import org.littleshoot.mina.common.ThreadModel;
import org.littleshoot.mina.filter.executor.ExecutorFilter;
import org.littleshoot.mina.util.NamePreservingRunnable;

public class ExecutorThreadModel
implements ThreadModel {
    private static final Map<String, ExecutorThreadModel> service2model = new HashMap<String, ExecutorThreadModel>();
    private final String threadNamePrefix;
    private final ExecutorFilter defaultFilter;
    private ExecutorFilter filter = new ExecutorFilter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorThreadModel getInstance(String serviceName) {
        ExecutorThreadModel model;
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        Map<String, ExecutorThreadModel> map = service2model;
        synchronized (map) {
            model = service2model.get(serviceName);
            if (model == null) {
                model = new ExecutorThreadModel(serviceName);
                service2model.put(serviceName, model);
            }
        }
        return model;
    }

    private ExecutorThreadModel(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
        this.defaultFilter = new ExecutorFilter();
        ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.defaultFilter.getExecutor();
        final ThreadFactory originalThreadFactory = tpe.getThreadFactory();
        ThreadFactory newThreadFactory = new ThreadFactory(){
            private final AtomicInteger threadId = new AtomicInteger(0);

            public Thread newThread(Runnable runnable) {
                Thread t = originalThreadFactory.newThread(new NamePreservingRunnable(runnable, ExecutorThreadModel.this.threadNamePrefix + '-' + this.threadId.incrementAndGet()));
                t.setDaemon(true);
                return t;
            }
        };
        tpe.setThreadFactory(newThreadFactory);
        this.setExecutor(null);
    }

    public Executor getExecutor() {
        return this.filter.getExecutor();
    }

    public void setExecutor(Executor executor) {
        this.filter = executor == null ? this.defaultFilter : new ExecutorFilter(executor);
    }

    public void buildFilterChain(IoFilterChain chain) throws Exception {
        chain.addFirst(ExecutorThreadModel.class.getName(), this.filter);
    }
}

