/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.mina.filter;

import java.io.IOException;
import java.io.InputStream;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.IoFilter;
import org.littleshoot.mina.common.IoFilterAdapter;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.common.WriteFuture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamWriteFilter
extends IoFilterAdapter {
    public static final int DEFAULT_STREAM_BUFFER_SIZE = 4096;
    public static final String CURRENT_STREAM = StreamWriteFilter.class.getName() + ".stream";
    protected static final String WRITE_REQUEST_QUEUE = StreamWriteFilter.class.getName() + ".queue";
    protected static final String INITIAL_WRITE_FUTURE = StreamWriteFilter.class.getName() + ".future";
    private int writeBufferSize = 4096;

    @Override
    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, IoFilter.WriteRequest writeRequest) throws Exception {
        if (session.getAttribute(CURRENT_STREAM) != null) {
            Queue<IoFilter.WriteRequest> queue = this.getWriteRequestQueue(session);
            if (queue == null) {
                queue = new ConcurrentLinkedQueue<IoFilter.WriteRequest>();
                session.setAttribute(WRITE_REQUEST_QUEUE, queue);
            }
            queue.add(writeRequest);
            return;
        }
        Object message = writeRequest.getMessage();
        if (message instanceof InputStream) {
            InputStream inputStream = (InputStream)message;
            ByteBuffer byteBuffer = this.getNextByteBuffer(inputStream);
            if (byteBuffer == null) {
                writeRequest.getFuture().setWritten(true);
                nextFilter.messageSent(session, message);
            } else {
                session.setAttribute(CURRENT_STREAM, inputStream);
                session.setAttribute(INITIAL_WRITE_FUTURE, writeRequest.getFuture());
                nextFilter.filterWrite(session, new IoFilter.WriteRequest(byteBuffer));
            }
        } else {
            nextFilter.filterWrite(session, writeRequest);
        }
    }

    private Queue<IoFilter.WriteRequest> getWriteRequestQueue(IoSession session) {
        return (Queue)session.getAttribute(WRITE_REQUEST_QUEUE);
    }

    @Override
    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        InputStream inputStream = (InputStream)session.getAttribute(CURRENT_STREAM);
        if (inputStream == null) {
            nextFilter.messageSent(session, message);
        } else {
            ByteBuffer byteBuffer = this.getNextByteBuffer(inputStream);
            if (byteBuffer == null) {
                session.removeAttribute(CURRENT_STREAM);
                WriteFuture writeFuture = (WriteFuture)session.removeAttribute(INITIAL_WRITE_FUTURE);
                Queue queue = (Queue)session.removeAttribute(WRITE_REQUEST_QUEUE);
                if (queue != null) {
                    IoFilter.WriteRequest wr = (IoFilter.WriteRequest)queue.poll();
                    while (wr != null) {
                        this.filterWrite(nextFilter, session, wr);
                        wr = (IoFilter.WriteRequest)queue.poll();
                    }
                }
                writeFuture.setWritten(true);
                nextFilter.messageSent(session, inputStream);
            } else {
                nextFilter.filterWrite(session, new IoFilter.WriteRequest(byteBuffer));
            }
        }
    }

    private ByteBuffer getNextByteBuffer(InputStream is) throws IOException {
        int off;
        byte[] bytes = new byte[this.writeBufferSize];
        int n = 0;
        for (off = 0; off < bytes.length && (n = is.read(bytes, off, bytes.length - off)) != -1; off += n) {
        }
        if (n == -1 && off == 0) {
            return null;
        }
        return ByteBuffer.wrap(bytes, 0, off);
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(int writeBufferSize) {
        if (writeBufferSize < 1) {
            throw new IllegalArgumentException("writeBufferSize must be at least 1");
        }
        this.writeBufferSize = writeBufferSize;
    }
}

