/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.mina.filter.codec.support;

import java.util.LinkedList;
import java.util.Queue;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.WriteFuture;
import org.littleshoot.mina.filter.codec.ProtocolEncoderOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleProtocolEncoderOutput
implements ProtocolEncoderOutput {
    private final Queue<ByteBuffer> bufferQueue = new LinkedList<ByteBuffer>();

    public Queue<ByteBuffer> getBufferQueue() {
        return this.bufferQueue;
    }

    @Override
    public void write(ByteBuffer buf) {
        this.bufferQueue.add(buf);
    }

    @Override
    public void mergeAll() {
        ByteBuffer buf;
        int sum = 0;
        int size = this.bufferQueue.size();
        if (size < 2) {
            return;
        }
        for (ByteBuffer o : this.bufferQueue) {
            sum += o.remaining();
        }
        ByteBuffer newBuf = ByteBuffer.allocate(sum);
        while ((buf = this.bufferQueue.poll()) != null) {
            newBuf.put(buf);
            buf.release();
        }
        newBuf.flip();
        this.bufferQueue.offer(newBuf);
    }

    @Override
    public WriteFuture flush() {
        ByteBuffer buf;
        Queue<ByteBuffer> bufferQueue = this.bufferQueue;
        WriteFuture future = null;
        if (bufferQueue.isEmpty()) {
            return null;
        }
        while ((buf = bufferQueue.poll()) != null) {
            if (!buf.hasRemaining()) continue;
            future = this.doFlush(buf);
        }
        return future;
    }

    protected abstract WriteFuture doFlush(ByteBuffer var1);
}

