/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.mina.transport.socket.nio.support;

import java.util.Queue;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.IoFilter;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.common.support.AbstractIoFilterChain;
import org.littleshoot.mina.transport.socket.nio.support.DatagramAcceptorDelegate;
import org.littleshoot.mina.transport.socket.nio.support.DatagramConnectorDelegate;
import org.littleshoot.mina.transport.socket.nio.support.DatagramService;
import org.littleshoot.mina.transport.socket.nio.support.DatagramSessionImpl;

class DatagramFilterChain
extends AbstractIoFilterChain {
    DatagramFilterChain(IoSession parent) {
        super(parent);
    }

    protected void doWrite(IoSession session, IoFilter.WriteRequest writeRequest) {
        DatagramSessionImpl s = (DatagramSessionImpl)session;
        Queue<IoFilter.WriteRequest> writeRequestQueue = s.getWriteRequestQueue();
        ByteBuffer buffer = (ByteBuffer)writeRequest.getMessage();
        buffer.mark();
        int remaining = buffer.remaining();
        if (remaining == 0) {
            s.increaseScheduledWriteRequests();
        } else {
            s.increaseScheduledWriteBytes(buffer.remaining());
        }
        writeRequestQueue.add(writeRequest);
        if (session.getTrafficMask().isWritable()) {
            s.getManagerDelegate().flushSession(s);
        }
    }

    protected void doClose(IoSession session) {
        DatagramSessionImpl s = (DatagramSessionImpl)session;
        DatagramService manager = s.getManagerDelegate();
        if (manager instanceof DatagramConnectorDelegate) {
            manager.closeSession(s);
        } else {
            ((DatagramAcceptorDelegate)manager).getListeners().fireSessionDestroyed(session);
            session.getCloseFuture().setClosed();
        }
    }
}

