/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.mina.transport.socket.nio.support;

import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.littleshoot.mina.common.BroadcastIoSession;
import org.littleshoot.mina.common.IoFilter;
import org.littleshoot.mina.common.IoFilterChain;
import org.littleshoot.mina.common.IoHandler;
import org.littleshoot.mina.common.IoService;
import org.littleshoot.mina.common.IoServiceConfig;
import org.littleshoot.mina.common.IoSessionConfig;
import org.littleshoot.mina.common.RuntimeIOException;
import org.littleshoot.mina.common.TransportType;
import org.littleshoot.mina.common.support.BaseIoSession;
import org.littleshoot.mina.transport.socket.nio.DatagramServiceConfig;
import org.littleshoot.mina.transport.socket.nio.DatagramSessionConfig;
import org.littleshoot.mina.transport.socket.nio.support.DatagramFilterChain;
import org.littleshoot.mina.transport.socket.nio.support.DatagramService;
import org.littleshoot.mina.transport.socket.nio.support.DatagramSessionConfigImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatagramSessionImpl
extends BaseIoSession
implements BroadcastIoSession {
    private final IoService wrapperManager;
    private final IoServiceConfig serviceConfig;
    private final DatagramSessionConfig config = new SessionConfigImpl();
    private final DatagramService managerDelegate;
    private final DatagramFilterChain filterChain;
    private final DatagramChannel ch;
    private final Queue<IoFilter.WriteRequest> writeRequestQueue;
    private final IoHandler handler;
    private final SocketAddress localAddress;
    private final SocketAddress serviceAddress;
    private SocketAddress remoteAddress;
    private SelectionKey key;
    private int readBufferSize;

    DatagramSessionImpl(IoService wrapperManager, DatagramService managerDelegate, IoServiceConfig serviceConfig, DatagramChannel ch, IoHandler defaultHandler, SocketAddress serviceAddress, SocketAddress localAddress) {
        this.wrapperManager = wrapperManager;
        this.managerDelegate = managerDelegate;
        this.filterChain = new DatagramFilterChain(this);
        this.ch = ch;
        this.writeRequestQueue = new ConcurrentLinkedQueue<IoFilter.WriteRequest>();
        this.handler = defaultHandler;
        this.remoteAddress = ch.socket().getRemoteSocketAddress();
        this.serviceAddress = serviceAddress;
        this.localAddress = localAddress;
        this.serviceConfig = serviceConfig;
        IoSessionConfig sessionConfig = serviceConfig.getSessionConfig();
        if (sessionConfig instanceof DatagramSessionConfig) {
            DatagramSessionConfig cfg = (DatagramSessionConfig)sessionConfig;
            this.config.setBroadcast(cfg.isBroadcast());
            this.config.setReceiveBufferSize(cfg.getReceiveBufferSize());
            this.config.setReuseAddress(cfg.isReuseAddress());
            this.config.setSendBufferSize(cfg.getSendBufferSize());
            if (this.config.getTrafficClass() != cfg.getTrafficClass()) {
                this.config.setTrafficClass(cfg.getTrafficClass());
            }
        }
    }

    @Override
    public IoService getService() {
        return this.wrapperManager;
    }

    @Override
    public IoServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    @Override
    public IoSessionConfig getConfig() {
        return this.config;
    }

    DatagramService getManagerDelegate() {
        return this.managerDelegate;
    }

    @Override
    public IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    public DatagramChannel getChannel() {
        return this.ch;
    }

    SelectionKey getSelectionKey() {
        return this.key;
    }

    void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    @Override
    public IoHandler getHandler() {
        return this.handler;
    }

    @Override
    protected void close0() {
        IoServiceConfig config = this.getServiceConfig();
        if (config instanceof DatagramServiceConfig) {
            ((DatagramServiceConfig)config).getSessionRecycler().remove(this);
        }
        this.filterChain.fireFilterClose(this);
    }

    Queue<IoFilter.WriteRequest> getWriteRequestQueue() {
        return this.writeRequestQueue;
    }

    @Override
    protected void write0(IoFilter.WriteRequest writeRequest) {
        this.filterChain.fireFilterWrite(this, writeRequest);
    }

    @Override
    public TransportType getTransportType() {
        return TransportType.DATAGRAM;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    void setRemoteAddress(SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public SocketAddress getServiceAddress() {
        return this.serviceAddress;
    }

    @Override
    protected void updateTrafficMask() {
        this.managerDelegate.updateTrafficMask(this);
    }

    int getReadBufferSize() {
        return this.readBufferSize;
    }

    private class SessionConfigImpl
    extends DatagramSessionConfigImpl
    implements DatagramSessionConfig {
        private SessionConfigImpl() {
        }

        public int getReceiveBufferSize() {
            try {
                return DatagramSessionImpl.this.ch.socket().getReceiveBufferSize();
            }
            catch (SocketException e) {
                throw new RuntimeIOException(e);
            }
        }

        public void setReceiveBufferSize(int receiveBufferSize) {
            if (DatagramSessionConfigImpl.isSetReceiveBufferSizeAvailable()) {
                try {
                    DatagramSessionImpl.this.ch.socket().setReceiveBufferSize(receiveBufferSize);
                    receiveBufferSize = DatagramSessionImpl.this.ch.socket().getReceiveBufferSize();
                    DatagramSessionImpl.this.readBufferSize = receiveBufferSize;
                }
                catch (SocketException e) {
                    throw new RuntimeIOException(e);
                }
            }
        }

        public boolean isBroadcast() {
            try {
                return DatagramSessionImpl.this.ch.socket().getBroadcast();
            }
            catch (SocketException e) {
                throw new RuntimeIOException(e);
            }
        }

        public void setBroadcast(boolean broadcast) {
            try {
                DatagramSessionImpl.this.ch.socket().setBroadcast(broadcast);
            }
            catch (SocketException e) {
                throw new RuntimeIOException(e);
            }
        }

        public int getSendBufferSize() {
            try {
                return DatagramSessionImpl.this.ch.socket().getSendBufferSize();
            }
            catch (SocketException e) {
                throw new RuntimeIOException(e);
            }
        }

        public void setSendBufferSize(int sendBufferSize) {
            if (DatagramSessionConfigImpl.isSetSendBufferSizeAvailable()) {
                try {
                    DatagramSessionImpl.this.ch.socket().setSendBufferSize(sendBufferSize);
                }
                catch (SocketException e) {
                    throw new RuntimeIOException(e);
                }
            }
        }

        public boolean isReuseAddress() {
            try {
                return DatagramSessionImpl.this.ch.socket().getReuseAddress();
            }
            catch (SocketException e) {
                throw new RuntimeIOException(e);
            }
        }

        public void setReuseAddress(boolean reuseAddress) {
            try {
                DatagramSessionImpl.this.ch.socket().setReuseAddress(reuseAddress);
            }
            catch (SocketException e) {
                throw new RuntimeIOException(e);
            }
        }

        public int getTrafficClass() {
            if (DatagramSessionConfigImpl.isGetTrafficClassAvailable()) {
                try {
                    return DatagramSessionImpl.this.ch.socket().getTrafficClass();
                }
                catch (SocketException e) {
                    throw new RuntimeIOException(e);
                }
            }
            return 0;
        }

        public void setTrafficClass(int trafficClass) {
            if (DatagramSessionConfigImpl.isSetTrafficClassAvailable()) {
                try {
                    DatagramSessionImpl.this.ch.socket().setTrafficClass(trafficClass);
                }
                catch (SocketException e) {
                    throw new RuntimeIOException(e);
                }
            }
        }
    }
}

