/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.mina.transport.vmpipe.support;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.IdleStatus;
import org.littleshoot.mina.common.IoFilter;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.common.support.AbstractIoFilterChain;
import org.littleshoot.mina.transport.vmpipe.support.VmPipeSessionImpl;

public class VmPipeFilterChain
extends AbstractIoFilterChain {
    private final Queue<Event> eventQueue = new ConcurrentLinkedQueue<Event>();
    private volatile boolean flushEnabled;
    private volatile boolean sessionOpened;

    public VmPipeFilterChain(IoSession session) {
        super(session);
    }

    public void start() {
        this.flushEnabled = true;
        this.flushEvents();
        VmPipeFilterChain.flushPendingDataQueues((VmPipeSessionImpl)this.getSession());
    }

    private void pushEvent(Event e) {
        this.eventQueue.offer(e);
        if (this.flushEnabled) {
            this.flushEvents();
        }
    }

    private void flushEvents() {
        Event e;
        while ((e = this.eventQueue.poll()) != null) {
            this.fireEvent(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(Event e) {
        VmPipeSessionImpl session = (VmPipeSessionImpl)this.getSession();
        EventType type = e.getType();
        Object data = e.getData();
        if (type == EventType.RECEIVED) {
            if (this.sessionOpened && session.getTrafficMask().isReadable() && session.getLock().tryLock()) {
                try {
                    int byteCount = 1;
                    if (data instanceof ByteBuffer) {
                        byteCount = ((ByteBuffer)data).remaining();
                    }
                    session.increaseReadBytes(byteCount);
                    super.fireMessageReceived(session, data);
                }
                finally {
                    session.getLock().unlock();
                }
                VmPipeFilterChain.flushPendingDataQueues(session);
            } else {
                session.pendingDataQueue.add(data);
            }
        } else if (type == EventType.WRITE) {
            super.fireFilterWrite(session, (IoFilter.WriteRequest)data);
        } else if (type == EventType.SENT) {
            super.fireMessageSent(session, (IoFilter.WriteRequest)data);
        } else if (type == EventType.EXCEPTION) {
            super.fireExceptionCaught(session, (Throwable)data);
        } else if (type == EventType.IDLE) {
            super.fireSessionIdle(session, (IdleStatus)data);
        } else if (type == EventType.OPENED) {
            super.fireSessionOpened(session);
            this.sessionOpened = true;
        } else if (type == EventType.CREATED) {
            session.getLock().lock();
            try {
                super.fireSessionCreated(session);
            }
            finally {
                session.getLock().unlock();
            }
        } else if (type == EventType.CLOSED) {
            super.fireSessionClosed(session);
        } else if (type == EventType.CLOSE) {
            super.fireFilterClose(session);
        }
    }

    private static void flushPendingDataQueues(VmPipeSessionImpl s) {
        s.updateTrafficMask();
        s.getRemoteSession().updateTrafficMask();
    }

    public void fireFilterClose(IoSession session) {
        this.pushEvent(new Event(EventType.CLOSE, null));
    }

    public void fireFilterWrite(IoSession session, IoFilter.WriteRequest writeRequest) {
        this.pushEvent(new Event(EventType.WRITE, writeRequest));
    }

    public void fireExceptionCaught(IoSession session, Throwable cause) {
        this.pushEvent(new Event(EventType.EXCEPTION, cause));
    }

    public void fireMessageSent(IoSession session, IoFilter.WriteRequest request) {
        this.pushEvent(new Event(EventType.SENT, request));
    }

    public void fireSessionClosed(IoSession session) {
        this.pushEvent(new Event(EventType.CLOSED, null));
    }

    public void fireSessionCreated(IoSession session) {
        this.pushEvent(new Event(EventType.CREATED, null));
    }

    public void fireSessionIdle(IoSession session, IdleStatus status) {
        this.pushEvent(new Event(EventType.IDLE, status));
    }

    public void fireSessionOpened(IoSession session) {
        this.pushEvent(new Event(EventType.OPENED, null));
    }

    public void fireMessageReceived(IoSession session, Object message) {
        this.pushEvent(new Event(EventType.RECEIVED, message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWrite(IoSession session, IoFilter.WriteRequest writeRequest) {
        VmPipeSessionImpl s = (VmPipeSessionImpl)session;
        if (s.isConnected()) {
            if (s.getTrafficMask().isWritable() && s.getLock().tryLock()) {
                try {
                    Object message = writeRequest.getMessage();
                    int byteCount = 1;
                    Object messageCopy = message;
                    if (message instanceof ByteBuffer) {
                        ByteBuffer rb = (ByteBuffer)message;
                        rb.mark();
                        byteCount = rb.remaining();
                        ByteBuffer wb = ByteBuffer.allocate(rb.remaining());
                        wb.put(rb);
                        wb.flip();
                        rb.reset();
                        messageCopy = wb;
                    }
                    s.increaseScheduledWriteBytes(byteCount);
                    s.increaseScheduledWriteRequests();
                    s.increaseWrittenBytes(byteCount);
                    s.increaseWrittenMessages();
                    s.getRemoteSession().getFilterChain().fireMessageReceived(s.getRemoteSession(), messageCopy);
                    s.getFilterChain().fireMessageSent(s, writeRequest);
                }
                finally {
                    s.getLock().unlock();
                }
                VmPipeFilterChain.flushPendingDataQueues(s);
            } else {
                s.pendingDataQueue.add(writeRequest);
            }
        } else {
            writeRequest.getFuture().setWritten(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose(IoSession session) {
        VmPipeSessionImpl s = (VmPipeSessionImpl)session;
        try {
            s.getLock().lock();
            if (!session.getCloseFuture().isClosed()) {
                s.getServiceListeners().fireSessionDestroyed(s);
                s.getRemoteSession().close();
            }
        }
        finally {
            s.getLock().unlock();
        }
    }

    private static class Event {
        private final EventType type;
        private final Object data;

        private Event(EventType type, Object data) {
            this.type = type;
            this.data = data;
        }

        public Object getData() {
            return this.data;
        }

        public EventType getType() {
            return this.type;
        }
    }

    private static class EventType {
        public static final EventType CREATED = new EventType("CREATED");
        public static final EventType OPENED = new EventType("OPENED");
        public static final EventType CLOSED = new EventType("CLOSED");
        public static final EventType RECEIVED = new EventType("RECEIVED");
        public static final EventType SENT = new EventType("SENT");
        public static final EventType IDLE = new EventType("IDLE");
        public static final EventType EXCEPTION = new EventType("EXCEPTION");
        public static final EventType WRITE = new EventType("WRITE");
        public static final EventType CLOSE = new EventType("CLOSE");
        private final String value;

        private EventType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

