/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.mina.common.support;

import java.util.ArrayList;
import java.util.List;
import org.littleshoot.mina.common.ExceptionMonitor;
import org.littleshoot.mina.common.IoFuture;
import org.littleshoot.mina.common.IoFutureListener;
import org.littleshoot.mina.common.IoSession;

public class DefaultIoFuture
implements IoFuture {
    private final IoSession session;
    private final Object lock;
    private IoFutureListener firstListener;
    private List<IoFutureListener> otherListeners;
    private Object result;
    private boolean ready;
    private int waiters;

    public DefaultIoFuture(IoSession session) {
        this.session = session;
        this.lock = this;
    }

    public DefaultIoFuture(IoSession session, Object lock) {
        this.session = session;
        this.lock = lock;
    }

    @Override
    public IoSession getSession() {
        return this.session;
    }

    @Override
    public Object getLock() {
        return this.lock;
    }

    @Override
    public void join() {
        this.awaitUninterruptibly();
    }

    @Override
    public boolean join(long timeoutMillis) {
        return this.awaitUninterruptibly(timeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IoFuture awaitUninterruptibly() {
        Object object = this.lock;
        synchronized (object) {
            while (!this.ready) {
                ++this.waiters;
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
                continue;
                finally {
                    --this.waiters;
                }
            }
        }
        return this;
    }

    private boolean awaitUninterruptibly(long timeoutMillis) {
        try {
            return this.await0(timeoutMillis, false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean await0(long timeoutMillis, boolean interruptable) throws InterruptedException {
        long startTime = timeoutMillis <= 0L ? 0L : System.currentTimeMillis();
        long waitTime = timeoutMillis;
        Object object = this.lock;
        synchronized (object) {
            if (this.ready) {
                return this.ready;
            }
            if (waitTime <= 0L) {
                return this.ready;
            }
            ++this.waiters;
            try {
                do {
                    block11: {
                        try {
                            this.lock.wait(waitTime);
                        }
                        catch (InterruptedException e) {
                            if (!interruptable) break block11;
                            throw e;
                        }
                    }
                    if (!this.ready) continue;
                    boolean bl = true;
                    return bl;
                } while ((waitTime = timeoutMillis - (System.currentTimeMillis() - startTime)) > 0L);
                boolean bl = this.ready;
                return bl;
            }
            finally {
                --this.waiters;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReady() {
        Object object = this.lock;
        synchronized (object) {
            return this.ready;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setValue(Object newValue) {
        Object object = this.lock;
        synchronized (object) {
            if (this.ready) {
                return;
            }
            this.result = newValue;
            this.ready = true;
            if (this.waiters > 0) {
                this.lock.notifyAll();
            }
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getValue() {
        Object object = this.lock;
        synchronized (object) {
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(IoFutureListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        boolean notifyNow = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.ready) {
                notifyNow = true;
            } else if (this.firstListener == null) {
                this.firstListener = listener;
            } else {
                if (this.otherListeners == null) {
                    this.otherListeners = new ArrayList<IoFutureListener>(1);
                }
                this.otherListeners.add(listener);
            }
        }
        if (notifyNow) {
            this.notifyListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(IoFutureListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.ready) {
                if (listener == this.firstListener) {
                    this.firstListener = this.otherListeners != null && !this.otherListeners.isEmpty() ? this.otherListeners.remove(0) : null;
                } else if (this.otherListeners != null) {
                    this.otherListeners.remove(listener);
                }
            }
        }
    }

    private void notifyListeners() {
        if (this.firstListener != null) {
            this.notifyListener(this.firstListener);
            this.firstListener = null;
            if (this.otherListeners != null) {
                for (IoFutureListener l : this.otherListeners) {
                    this.notifyListener(l);
                }
                this.otherListeners = null;
            }
        }
    }

    private void notifyListener(IoFutureListener l) {
        try {
            l.operationComplete(this);
        }
        catch (Throwable t) {
            ExceptionMonitor.getInstance().exceptionCaught(t);
        }
    }
}

