/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.mina.transport.socket.nio.support;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.ConnectFuture;
import org.littleshoot.mina.common.ExceptionMonitor;
import org.littleshoot.mina.common.IoConnector;
import org.littleshoot.mina.common.IoFilter;
import org.littleshoot.mina.common.IoHandler;
import org.littleshoot.mina.common.IoServiceConfig;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.common.IoSessionRecycler;
import org.littleshoot.mina.common.support.AbstractIoFilterChain;
import org.littleshoot.mina.common.support.BaseIoConnector;
import org.littleshoot.mina.common.support.DefaultConnectFuture;
import org.littleshoot.mina.transport.socket.nio.DatagramConnectorConfig;
import org.littleshoot.mina.transport.socket.nio.DatagramServiceConfig;
import org.littleshoot.mina.transport.socket.nio.DatagramSessionConfig;
import org.littleshoot.mina.transport.socket.nio.support.DatagramService;
import org.littleshoot.mina.transport.socket.nio.support.DatagramSessionImpl;
import org.littleshoot.mina.util.NamePreservingRunnable;

public class DatagramConnectorDelegate
extends BaseIoConnector
implements DatagramService {
    private static final AtomicInteger nextId = new AtomicInteger();
    private final Object lock = new Object();
    private final IoConnector wrapper;
    private final Executor executor;
    private final int id = nextId.getAndIncrement();
    private volatile Selector selector;
    private DatagramConnectorConfig defaultConfig = new DatagramConnectorConfig();
    private final Queue<RegistrationRequest> registerQueue = new ConcurrentLinkedQueue<RegistrationRequest>();
    private final Queue<DatagramSessionImpl> cancelQueue = new ConcurrentLinkedQueue<DatagramSessionImpl>();
    private final Queue<DatagramSessionImpl> flushingSessions = new ConcurrentLinkedQueue<DatagramSessionImpl>();
    private final Queue<DatagramSessionImpl> trafficControllingSessions = new ConcurrentLinkedQueue<DatagramSessionImpl>();
    private Worker worker;

    public DatagramConnectorDelegate(IoConnector wrapper, Executor executor) {
        this.wrapper = wrapper;
        this.executor = executor;
    }

    @Override
    public ConnectFuture connect(SocketAddress address, IoHandler handler, IoServiceConfig config) {
        return this.connect(address, null, handler, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectFuture connect(SocketAddress address, SocketAddress localAddress, IoHandler handler, IoServiceConfig config) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected address type: " + address.getClass());
        }
        if (localAddress != null && !(localAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected local address type: " + localAddress.getClass());
        }
        if (config == null) {
            config = this.getDefaultConfig();
        }
        DatagramChannel ch = null;
        boolean initialized = false;
        try {
            ch = DatagramChannel.open();
            DatagramSessionConfig cfg = config.getSessionConfig() instanceof DatagramSessionConfig ? (DatagramSessionConfig)config.getSessionConfig() : this.getDefaultConfig().getSessionConfig();
            ch.socket().setReuseAddress(cfg.isReuseAddress());
            ch.socket().setBroadcast(cfg.isBroadcast());
            ch.socket().setReceiveBufferSize(cfg.getReceiveBufferSize());
            ch.socket().setSendBufferSize(cfg.getSendBufferSize());
            if (ch.socket().getTrafficClass() != cfg.getTrafficClass()) {
                ch.socket().setTrafficClass(cfg.getTrafficClass());
            }
            if (localAddress != null) {
                ch.socket().bind(localAddress);
            }
            ch.connect(address);
            ch.configureBlocking(false);
            initialized = true;
        }
        catch (IOException e) {
            ConnectFuture connectFuture = DefaultConnectFuture.newFailedFuture(e);
            return connectFuture;
        }
        finally {
            if (!initialized && ch != null) {
                try {
                    ch.disconnect();
                    ch.close();
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
        RegistrationRequest request = new RegistrationRequest(ch, handler, config);
        Object object = this.lock;
        synchronized (object) {
            try {
                this.startupWorker();
            }
            catch (IOException e) {
                try {
                    ch.disconnect();
                    ch.close();
                }
                catch (IOException e2) {
                    ExceptionMonitor.getInstance().exceptionCaught(e2);
                }
                return DefaultConnectFuture.newFailedFuture(e);
            }
            this.registerQueue.add(request);
            this.selector.wakeup();
        }
        return request;
    }

    @Override
    public DatagramConnectorConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(DatagramConnectorConfig defaultConfig) {
        if (defaultConfig == null) {
            throw new NullPointerException("defaultConfig");
        }
        this.defaultConfig = defaultConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startupWorker() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.worker == null) {
                this.selector = Selector.open();
                this.worker = new Worker();
                this.executor.execute(new NamePreservingRunnable(this.worker, "DatagramConnector-" + this.id));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSession(DatagramSessionImpl session) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.startupWorker();
            }
            catch (IOException e) {
                return;
            }
            this.cancelQueue.add(session);
            this.selector.wakeup();
        }
    }

    @Override
    public void flushSession(DatagramSessionImpl session) {
        Selector selector;
        if (this.scheduleFlush(session) && (selector = this.selector) != null) {
            selector.wakeup();
        }
    }

    private boolean scheduleFlush(DatagramSessionImpl session) {
        if (session.setScheduledForFlush(true)) {
            this.flushingSessions.add(session);
            return true;
        }
        return false;
    }

    @Override
    public void updateTrafficMask(DatagramSessionImpl session) {
        this.scheduleTrafficControl(session);
        Selector selector = this.selector;
        if (selector != null) {
            selector.wakeup();
        }
    }

    private void scheduleTrafficControl(DatagramSessionImpl session) {
        this.trafficControllingSessions.add(session);
    }

    private void doUpdateTrafficMask() {
        DatagramSessionImpl session;
        if (this.trafficControllingSessions.isEmpty()) {
            return;
        }
        while ((session = this.trafficControllingSessions.poll()) != null) {
            SelectionKey key = session.getSelectionKey();
            if (key == null) {
                this.scheduleTrafficControl(session);
                break;
            }
            if (!key.isValid()) continue;
            int ops = 1;
            if (!session.getWriteRequestQueue().isEmpty()) {
                ops |= 4;
            }
            int mask = session.getTrafficMask().getInterestOps();
            key.interestOps(ops & mask);
        }
    }

    private void processReadySessions(Set<SelectionKey> keys) {
        Iterator<SelectionKey> it = keys.iterator();
        while (it.hasNext()) {
            SelectionKey key = it.next();
            it.remove();
            DatagramSessionImpl session = (DatagramSessionImpl)key.attachment();
            this.getSessionRecycler(session).recycle(session.getLocalAddress(), session.getRemoteAddress());
            if (key.isReadable() && session.getTrafficMask().isReadable()) {
                this.readSession(session);
            }
            if (!key.isWritable() || !session.getTrafficMask().isWritable()) continue;
            this.scheduleFlush(session);
        }
    }

    private IoSessionRecycler getSessionRecycler(IoSession session) {
        IoServiceConfig config = session.getServiceConfig();
        IoSessionRecycler sessionRecycler = config instanceof DatagramServiceConfig ? ((DatagramServiceConfig)config).getSessionRecycler() : this.defaultConfig.getSessionRecycler();
        return sessionRecycler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSession(DatagramSessionImpl session) {
        ByteBuffer readBuf = ByteBuffer.allocate(session.getReadBufferSize());
        try {
            int readBytes = session.getChannel().read(readBuf.buf());
            if (readBytes > 0) {
                readBuf.flip();
                ByteBuffer newBuf = ByteBuffer.allocate(readBuf.limit());
                newBuf.put(readBuf);
                newBuf.flip();
                session.increaseReadBytes(readBytes);
                session.getFilterChain().fireMessageReceived(session, newBuf);
            }
        }
        catch (IOException e) {
            session.getFilterChain().fireExceptionCaught(session, e);
        }
        finally {
            readBuf.release();
        }
    }

    private void flushSessions() {
        DatagramSessionImpl session;
        if (this.flushingSessions.size() == 0) {
            return;
        }
        while ((session = this.flushingSessions.poll()) != null) {
            session.setScheduledForFlush(false);
            try {
                boolean flushedAll = this.flush(session);
                if (!flushedAll || session.getWriteRequestQueue().isEmpty() || session.isScheduledForFlush()) continue;
                this.scheduleFlush(session);
            }
            catch (IOException e) {
                session.getFilterChain().fireExceptionCaught(session, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flush(DatagramSessionImpl session) throws IOException {
        SelectionKey key = session.getSelectionKey();
        if (key == null) {
            this.scheduleFlush(session);
            return false;
        }
        if (!key.isValid()) {
            return false;
        }
        key.interestOps(key.interestOps() & 0xFFFFFFFB);
        DatagramChannel ch = session.getChannel();
        Queue<IoFilter.WriteRequest> writeRequestQueue = session.getWriteRequestQueue();
        int writtenBytes = 0;
        int maxWrittenBytes = ((DatagramSessionConfig)session.getConfig()).getSendBufferSize() << 1;
        try {
            IoFilter.WriteRequest req;
            while ((req = writeRequestQueue.peek()) != null) {
                ByteBuffer buf = (ByteBuffer)req.getMessage();
                if (buf.remaining() == 0) {
                    writeRequestQueue.poll();
                    buf.reset();
                    if (!buf.hasRemaining()) {
                        session.increaseWrittenMessages();
                    }
                    session.getFilterChain().fireMessageSent(session, req);
                    continue;
                }
                int localWrittenBytes = ch.write(buf.buf());
                if (localWrittenBytes == 0 || (writtenBytes += localWrittenBytes) >= maxWrittenBytes) {
                    key.interestOps(key.interestOps() | 4);
                    boolean bl = false;
                    return bl;
                }
                key.interestOps(key.interestOps() & 0xFFFFFFFB);
                writeRequestQueue.poll();
                buf.reset();
                if (!buf.hasRemaining()) {
                    session.increaseWrittenMessages();
                }
                session.getFilterChain().fireMessageSent(session, req);
            }
        }
        finally {
            session.increaseWrittenBytes(writtenBytes);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNew() {
        RegistrationRequest req;
        if (this.registerQueue.isEmpty()) {
            return;
        }
        Selector selector = this.selector;
        while ((req = this.registerQueue.poll()) != null) {
            DatagramSessionImpl session = new DatagramSessionImpl(this.wrapper, this, req.config, req.channel, req.handler, req.channel.socket().getRemoteSocketAddress(), req.channel.socket().getLocalSocketAddress());
            session.setAttribute(AbstractIoFilterChain.CONNECT_FUTURE, req);
            boolean success = false;
            try {
                SelectionKey key = req.channel.register(selector, 1, session);
                session.setSelectionKey(key);
                this.buildFilterChain(req, session);
                this.getSessionRecycler(session).put(session);
                this.getListeners().fireSessionCreated(session);
                success = true;
            }
            catch (Throwable t) {
                session.getFilterChain().fireExceptionCaught(session, t);
            }
            finally {
                if (success) continue;
                try {
                    req.channel.disconnect();
                    req.channel.close();
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                }
            }
        }
    }

    private void buildFilterChain(RegistrationRequest req, IoSession session) throws Exception {
        this.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
        req.config.getFilterChainBuilder().buildFilterChain(session.getFilterChain());
        req.config.getThreadModel().buildFilterChain(session.getFilterChain());
    }

    private void cancelKeys() {
        DatagramSessionImpl session;
        if (this.cancelQueue.isEmpty()) {
            return;
        }
        Selector selector = this.selector;
        while ((session = this.cancelQueue.poll()) != null) {
            SelectionKey key = session.getSelectionKey();
            DatagramChannel ch = (DatagramChannel)key.channel();
            try {
                ch.disconnect();
                ch.close();
            }
            catch (IOException e) {
                ExceptionMonitor.getInstance().exceptionCaught(e);
            }
            this.getListeners().fireSessionDestroyed(session);
            session.getCloseFuture().setClosed();
            key.cancel();
            selector.wakeup();
        }
    }

    private static class RegistrationRequest
    extends DefaultConnectFuture {
        private final DatagramChannel channel;
        private final IoHandler handler;
        private final IoServiceConfig config;

        private RegistrationRequest(DatagramChannel channel, IoHandler handler, IoServiceConfig config) {
            this.channel = channel;
            this.handler = handler;
            this.config = config;
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Selector selector = DatagramConnectorDelegate.this.selector;
            while (true) {
                try {
                    do {
                        int nKeys = selector.select();
                        DatagramConnectorDelegate.this.registerNew();
                        DatagramConnectorDelegate.this.doUpdateTrafficMask();
                        if (nKeys > 0) {
                            DatagramConnectorDelegate.this.processReadySessions(selector.selectedKeys());
                        }
                        DatagramConnectorDelegate.this.flushSessions();
                        DatagramConnectorDelegate.this.cancelKeys();
                    } while (!selector.keys().isEmpty());
                    Object object = DatagramConnectorDelegate.this.lock;
                    synchronized (object) {
                        if (selector.keys().isEmpty() && DatagramConnectorDelegate.this.registerQueue.isEmpty() && DatagramConnectorDelegate.this.cancelQueue.isEmpty()) {
                            DatagramConnectorDelegate.this.worker = null;
                            try {
                                selector.close();
                            }
                            catch (IOException e) {
                                ExceptionMonitor.getInstance().exceptionCaught(e);
                            }
                            finally {
                                DatagramConnectorDelegate.this.selector = null;
                            }
                            break;
                        }
                        continue;
                    }
                }
                catch (IOException e) {
                    ExceptionMonitor.getInstance().exceptionCaught(e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        ExceptionMonitor.getInstance().exceptionCaught(e1);
                    }
                    continue;
                }
                break;
            }
        }
    }
}

