/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.mina.handler.multiton;

import org.littleshoot.mina.common.IdleStatus;
import org.littleshoot.mina.common.IoHandler;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.handler.multiton.SingleSessionIoHandler;
import org.littleshoot.mina.handler.multiton.SingleSessionIoHandlerFactory;

public class SingleSessionIoHandlerDelegate
implements IoHandler {
    public static final String HANDLER = SingleSessionIoHandlerDelegate.class.getName() + ".handler";
    private final SingleSessionIoHandlerFactory factory;

    public SingleSessionIoHandlerDelegate(SingleSessionIoHandlerFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        this.factory = factory;
    }

    @Override
    public void sessionCreated(IoSession session) throws Exception {
        SingleSessionIoHandler handler = this.factory.getHandler(session);
        session.setAttribute(HANDLER, handler);
        handler.sessionCreated();
    }

    @Override
    public void sessionOpened(IoSession session) throws Exception {
        SingleSessionIoHandler handler = (SingleSessionIoHandler)session.getAttribute(HANDLER);
        handler.sessionOpened();
    }

    @Override
    public void sessionClosed(IoSession session) throws Exception {
        SingleSessionIoHandler handler = (SingleSessionIoHandler)session.getAttribute(HANDLER);
        handler.sessionClosed();
    }

    @Override
    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        SingleSessionIoHandler handler = (SingleSessionIoHandler)session.getAttribute(HANDLER);
        handler.sessionIdle(status);
    }

    @Override
    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        SingleSessionIoHandler handler = (SingleSessionIoHandler)session.getAttribute(HANDLER);
        handler.exceptionCaught(cause);
    }

    @Override
    public void messageReceived(IoSession session, Object message) throws Exception {
        SingleSessionIoHandler handler = (SingleSessionIoHandler)session.getAttribute(HANDLER);
        handler.messageReceived(message);
    }

    @Override
    public void messageSent(IoSession session, Object message) throws Exception {
        SingleSessionIoHandler handler = (SingleSessionIoHandler)session.getAttribute(HANDLER);
        handler.messageSent(message);
    }
}

