/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.mina.handler.support;

import java.io.IOException;
import java.io.OutputStream;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.common.WriteFuture;

public class IoSessionOutputStream
extends OutputStream {
    private final IoSession session;
    private WriteFuture lastWriteFuture;

    public IoSessionOutputStream(IoSession session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.session.close().join();
        }
    }

    private void checkClosed() throws IOException {
        if (!this.session.isConnected()) {
            throw new IOException("The session has been closed.");
        }
    }

    private synchronized void write(ByteBuffer buf) throws IOException {
        this.checkClosed();
        this.lastWriteFuture = this.session.write(buf);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.write(ByteBuffer.wrap((byte[])b.clone(), off, len));
    }

    @Override
    public void write(int b) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(1);
        buf.put((byte)b);
        buf.flip();
        this.write(buf);
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.lastWriteFuture == null) {
            return;
        }
        this.lastWriteFuture.join();
        if (!this.lastWriteFuture.isWritten()) {
            throw new IOException("The bytes could not be written to the session");
        }
    }
}

