/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util.mina;

import java.io.IOException;
import java.io.OutputStream;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.common.WriteFuture;
import org.littleshoot.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIoSessionOutputStream<T>
extends OutputStream {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    protected final IoSession m_ioSession;
    protected WriteFuture m_lastWriteFuture;

    protected AbstractIoSessionOutputStream(IoSession session) {
        this.m_ioSession = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.m_log.debug("Closing output stream from: " + ThreadUtils.dumpStack());
        try {
            this.flush();
        }
        finally {
            this.m_ioSession.close().join();
        }
    }

    private void checkClosed() throws IOException {
        if (!this.m_ioSession.isConnected()) {
            throw new IOException("The session has been closed.");
        }
    }

    protected synchronized void write(T message) throws IOException {
        this.m_log.debug("Writing message: {}", message);
        this.checkClosed();
        this.m_lastWriteFuture = this.m_ioSession.write(message);
        this.m_lastWriteFuture.join(this.m_ioSession.getWriteTimeoutInMillis());
        this.m_log.debug("Finshing writing message...");
    }

    @Override
    public synchronized void flush() throws IOException {
        this.m_log.debug("Flushing IoSession output stream...");
        if (this.m_lastWriteFuture == null) {
            return;
        }
        this.m_lastWriteFuture.join();
        if (!this.m_lastWriteFuture.isWritten()) {
            throw new IOException("The bytes could not be written to the session");
        }
    }
}

