/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util.mina;

import java.util.Collection;
import java.util.LinkedList;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.ByteBufferAllocator;
import org.littleshoot.mina.common.SimpleByteBufferAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ByteBufferUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ByteBufferUtils.class);

    public static Collection<ByteBuffer> split(ByteBuffer buffer, int chunkSize) {
        LinkedList<ByteBuffer> buffers = new LinkedList<ByteBuffer>();
        int limit = buffer.limit();
        int totalSent = 0;
        while (totalSent + chunkSize < limit) {
            LOG.trace("Setting limit to: " + (totalSent + chunkSize));
            buffer.limit(totalSent + chunkSize);
            buffers.add(ByteBufferUtils.createBuffer(buffer));
            totalSent += chunkSize;
        }
        buffer.limit(limit);
        buffers.add(ByteBufferUtils.createBuffer(buffer));
        return buffers;
    }

    private static ByteBuffer createBuffer(ByteBuffer buffer) {
        ByteBuffer data = ByteBuffer.allocate((int)(buffer.limit() - buffer.position()));
        LOG.trace("Created buffer with capacity: " + data.capacity());
        data.put(buffer);
        data.rewind();
        return data;
    }

    public static ByteBuffer combine(Collection<ByteBuffer> buffers) {
        ByteBuffer buf = ByteBuffer.allocate((int)ByteBufferUtils.remaining(buffers));
        for (ByteBuffer curBuf : buffers) {
            buf.put(curBuf);
        }
        buf.flip();
        return buf;
    }

    public static int remaining(Collection<ByteBuffer> buffers) {
        int remaining = 0;
        for (ByteBuffer buf : buffers) {
            remaining += buf.remaining();
        }
        return remaining;
    }

    public static void logBufferToWrite(ByteBuffer buffer) {
        LOG.trace("Writing: ");
        LOG.trace(ByteBufferUtils.toString(buffer));
    }

    public static String toString(ByteBuffer buffer) {
        int position = buffer.position();
        int limit = buffer.limit();
        byte[] data = new byte[buffer.remaining()];
        buffer.get(data);
        String dataString = new String(data);
        buffer.position(position);
        buffer.limit(limit);
        return dataString;
    }

    static {
        ByteBuffer.setUseDirectBuffers((boolean)false);
        ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
    }
}

