/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util.mina;

import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.filter.codec.ProtocolDecoderOutput;
import org.littleshoot.util.mina.DecodingState;

public abstract class ConsumeToCrlfDecodingState
implements DecodingState {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private boolean m_lastIsCr;
    private ByteBuffer m_buffer;

    @Override
    public DecodingState decode(ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        int beginPos = in.position();
        int limit = in.limit();
        int terminatorPos = -1;
        for (int i = beginPos; i < limit; ++i) {
            byte b = in.get(i);
            if (b == 13) {
                this.m_lastIsCr = true;
                continue;
            }
            if (b == 10 && this.m_lastIsCr) {
                terminatorPos = i;
                break;
            }
            this.m_lastIsCr = false;
        }
        if (terminatorPos >= 0) {
            ByteBuffer product;
            int endPos = terminatorPos - 1;
            if (beginPos < endPos) {
                in.limit(endPos);
                if (this.m_buffer == null) {
                    product = in.slice();
                } else {
                    this.m_buffer.put(in);
                    product = this.m_buffer.flip();
                    this.m_buffer = null;
                }
                in.limit(limit);
            } else if (this.m_buffer == null) {
                product = ByteBuffer.allocate((int)1);
                product.limit(0);
            } else {
                product = this.m_buffer.flip();
                this.m_buffer = null;
            }
            in.position(terminatorPos + 1);
            return this.finishDecode(product, out);
        }
        in.position(beginPos);
        if (this.m_buffer == null) {
            this.m_buffer = ByteBuffer.allocate((int)in.remaining());
            this.m_buffer.setAutoExpand(true);
        }
        this.m_buffer.put(in);
        if (this.m_lastIsCr) {
            this.m_buffer.position(this.m_buffer.position() - 1);
        }
        return this;
    }

    protected abstract DecodingState finishDecode(ByteBuffer var1, ProtocolDecoderOutput var2) throws Exception;
}

