/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util.mina;

import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.filter.codec.ProtocolDecoderOutput;
import org.littleshoot.util.mina.DecodingState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConsumeToTerminatorDecodingState
implements DecodingState {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private ByteBuffer m_buffer;
    private final byte m_terminator1;
    private final byte m_terminator2;
    private byte m_foundTerminator;

    protected ConsumeToTerminatorDecodingState(byte terminator) {
        this.m_terminator1 = terminator;
        this.m_terminator2 = (byte)-1;
    }

    protected ConsumeToTerminatorDecodingState(byte terminator1, byte terminator2) {
        this.m_terminator1 = terminator1;
        this.m_terminator2 = terminator2;
    }

    @Override
    public DecodingState decode(ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        int beginPos = in.position();
        int terminatorPos = -1;
        int limit = in.limit();
        for (int i = beginPos; i < limit; ++i) {
            byte b = in.get(i);
            if (b != this.m_terminator1 && b != this.m_terminator2) continue;
            this.m_foundTerminator = b;
            terminatorPos = i;
            break;
        }
        if (terminatorPos >= 0) {
            ByteBuffer product;
            if (beginPos < terminatorPos) {
                in.limit(terminatorPos);
                if (this.m_buffer == null) {
                    product = in.slice();
                } else {
                    this.m_buffer.put(in);
                    product = this.m_buffer.flip();
                    this.m_buffer = null;
                }
                in.limit(limit);
            } else if (this.m_buffer == null) {
                product = ByteBuffer.allocate((int)1);
                product.limit(0);
            } else {
                product = this.m_buffer.flip();
                this.m_buffer = null;
            }
            in.position(terminatorPos + 1);
            return this.finishDecode(this.m_foundTerminator, product, out);
        }
        if (this.m_buffer == null) {
            this.m_buffer = ByteBuffer.allocate((int)in.remaining());
            this.m_buffer.setAutoExpand(true);
        }
        this.m_buffer.put(in);
        return this;
    }

    protected abstract DecodingState finishDecode(byte var1, ByteBuffer var2, ProtocolDecoderOutput var3) throws Exception;
}

