/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util.mina;

import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.filter.codec.ProtocolDecoderException;
import org.littleshoot.mina.filter.codec.ProtocolDecoderOutput;
import org.littleshoot.util.mina.DecodingState;

public abstract class CrlfDecodingState
implements DecodingState {
    private boolean m_hasCarriageReturn;

    @Override
    public DecodingState decode(ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        boolean found = false;
        boolean finished = false;
        while (in.hasRemaining()) {
            byte b = in.get();
            if (!this.m_hasCarriageReturn) {
                if (b == 13) {
                    this.m_hasCarriageReturn = true;
                    continue;
                }
                if (b == 10) {
                    found = true;
                } else {
                    in.position(in.position() - 1);
                    found = false;
                }
                finished = true;
                break;
            }
            if (b == 10) {
                found = true;
                finished = true;
                break;
            }
            throw new ProtocolDecoderException("Expected LF after CR but was: " + b);
        }
        if (finished) {
            this.m_hasCarriageReturn = false;
            return this.finishDecode(found, out);
        }
        return this;
    }

    protected abstract DecodingState finishDecode(boolean var1, ProtocolDecoderOutput var2) throws Exception;
}

