/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util.mina;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.filter.codec.ProtocolDecoderOutput;
import org.littleshoot.util.mina.DecodingState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DecodingStateMachine
implements DecodingState {
    private final Logger LOG = LoggerFactory.getLogger(DecodingStateMachine.class);
    private final List<Object> m_childProducts = new ArrayList<Object>();
    private final ProtocolDecoderOutput m_childOutput = new ProtocolDecoderOutput(){

        public void flush() {
        }

        public void write(Object message) {
            DecodingStateMachine.this.m_childProducts.add(message);
        }
    };
    private DecodingState currentState;

    protected abstract DecodingState init() throws Exception;

    protected abstract DecodingState finishDecode(List<Object> var1, ProtocolDecoderOutput var2) throws Exception;

    protected abstract void destroy() throws Exception;

    @Override
    public DecodingState decode(ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        DecodingState state;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Decoding...");
        }
        if ((state = this.currentState) == null) {
            state = this.init();
        }
        int limit = in.limit();
        int pos = in.position();
        try {
            DecodingState oldState;
            while (true) {
                if (pos == limit) {
                    this.LOG.debug("Position at limit, breaking...");
                    break;
                }
                oldState = state;
                if ((state = state.decode(in, this.m_childOutput)) == null) {
                    if (this.LOG.isDebugEnabled()) {
                        this.debugStateTransition(oldState);
                    }
                    DecodingState returningState = this.finishDecode(this.m_childProducts, out);
                    if (this.LOG.isDebugEnabled()) {
                        this.debugStateTransition2(returningState, in);
                    }
                    DecodingState decodingState = returningState;
                    return decodingState;
                }
                int newPos = in.position();
                if (newPos == pos && oldState == state) {
                    this.LOG.debug("No data consumed and no state change...returning");
                    break;
                }
                pos = newPos;
            }
            oldState = this;
            return oldState;
        }
        catch (Exception e) {
            this.LOG.warn("Caught exception!!", (Throwable)e);
            state = null;
            throw e;
        }
        finally {
            this.currentState = state;
            if (state == null) {
                this.m_childProducts.clear();
                try {
                    this.destroy();
                }
                catch (Exception e2) {
                    this.LOG.warn("Failed to destroy a decoding state machine.", (Throwable)e2);
                }
            }
        }
    }

    private void debugStateTransition(DecodingState oldState) {
        this.LOG.debug("This state: {}", (Object)ClassUtils.getShortClassName(this.getClass()));
        this.LOG.debug("Got null from " + ClassUtils.getShortClassName(oldState.getClass()));
        this.LOG.debug("Finishing decode for state: {}", (Object)ClassUtils.getShortClassName(this.getClass()));
    }

    private void debugStateTransition2(DecodingState returningState, ByteBuffer in) {
        String stateString = returningState != null ? ClassUtils.getShortClassName(returningState.getClass()) : null;
        this.LOG.debug(ClassUtils.getShortClassName(this.getClass()) + " transitioning to state: {}", (Object)stateString);
        this.LOG.debug("Remaining bytes: " + in.remaining());
        if (in.remaining() == 1) {
            this.LOG.debug("Remaining byte: '" + in.get() + "'");
        }
    }
}

