/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util.mina;

import org.littleshoot.mina.common.IdleStatus;
import org.littleshoot.mina.common.IoHandler;
import org.littleshoot.mina.common.IoHandlerAdapter;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DemuxingIoHandler<T, Z>
extends IoHandlerAdapter {
    private final Logger m_log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Class<T> m_class1;
    private final Class<Z> m_class2;
    private final IoHandler m_ioHandler1;
    private final IoHandler m_ioHandler2;

    public DemuxingIoHandler(Class<T> class1, IoHandler ioHandler1, Class<Z> class2, IoHandler ioHandler2) {
        if (class1 == null) {
            throw new NullPointerException("Null first class");
        }
        if (class2 == null) {
            throw new NullPointerException("Null second class");
        }
        if (ioHandler1 == null) {
            throw new NullPointerException("Null first handler");
        }
        if (ioHandler2 == null) {
            throw new NullPointerException("Null second handler");
        }
        this.m_class1 = class1;
        this.m_class2 = class2;
        this.m_ioHandler1 = ioHandler1;
        this.m_ioHandler2 = ioHandler2;
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        this.m_log.debug("Caught exception", cause);
        this.m_log.debug("Cause trace: " + ThreadUtils.dumpStack((Throwable)cause.getCause()));
        this.m_ioHandler1.exceptionCaught(session, cause);
        this.m_ioHandler2.exceptionCaught(session, cause);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        this.m_log.debug("Received message...");
        IoHandler handler = this.getHandlerForMessage(message);
        if (handler != null) {
            handler.messageReceived(session, message);
        }
    }

    public void messageSent(IoSession session, Object message) throws Exception {
        this.m_log.debug("Sent message...");
        IoHandler handler = this.getHandlerForMessage(message);
        if (handler != null) {
            handler.messageSent(session, message);
        }
    }

    private IoHandler getHandlerForMessage(Object message) {
        if (this.m_class1.isAssignableFrom(message.getClass())) {
            return this.m_ioHandler1;
        }
        if (this.m_class2.isAssignableFrom(message.getClass())) {
            return this.m_ioHandler2;
        }
        this.m_log.warn("Could not find IoHandler for message: {}", message);
        this.m_log.warn("Existing classes: " + this.m_class1 + " and " + this.m_class2);
        return null;
    }

    public void sessionClosed(IoSession session) throws Exception {
        this.m_ioHandler1.sessionClosed(session);
        this.m_ioHandler2.sessionClosed(session);
    }

    public void sessionCreated(IoSession session) throws Exception {
        this.m_ioHandler1.sessionCreated(session);
        this.m_ioHandler2.sessionCreated(session);
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        this.m_ioHandler1.sessionIdle(session, status);
        this.m_ioHandler2.sessionIdle(session, status);
    }

    public void sessionOpened(IoSession session) throws Exception {
        this.m_ioHandler1.sessionOpened(session);
        this.m_ioHandler2.sessionOpened(session);
    }
}

