/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util.mina;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.filter.codec.ProtocolCodecFactory;
import org.littleshoot.mina.filter.codec.ProtocolDecoder;
import org.littleshoot.mina.filter.codec.ProtocolDecoderOutput;
import org.littleshoot.mina.filter.codec.ProtocolEncoder;
import org.littleshoot.mina.filter.codec.ProtocolEncoderOutput;
import org.littleshoot.util.mina.DemuxableProtocolCodecFactory;
import org.littleshoot.util.mina.DemuxableProtocolDecoder;
import org.littleshoot.util.mina.MinaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DemuxingProtocolCodecFactory
implements ProtocolCodecFactory {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final List<DemuxableProtocolCodecFactory> m_codecFactories = new LinkedList<DemuxableProtocolCodecFactory>();

    public DemuxingProtocolCodecFactory(DemuxableProtocolCodecFactory firstCodecFactory, DemuxableProtocolCodecFactory secondCodecFactory) {
        if (firstCodecFactory == null) {
            throw new NullPointerException("Null first factory");
        }
        if (secondCodecFactory == null) {
            throw new NullPointerException("Null second factory");
        }
        this.m_codecFactories.add(firstCodecFactory);
        this.m_codecFactories.add(secondCodecFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtocolDecoder getDecoder() {
        this.m_log.debug("Returning decoder...");
        List<DemuxableProtocolCodecFactory> list = this.m_codecFactories;
        synchronized (list) {
            return new DemuxingProtocolDecoder(this.m_codecFactories);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtocolEncoder getEncoder() {
        this.m_log.debug("Returning encoder...");
        List<DemuxableProtocolCodecFactory> list = this.m_codecFactories;
        synchronized (list) {
            return new DemuxingProtocolEncoder(this.m_codecFactories);
        }
    }

    private static final class DemuxingProtocolDecoder
    implements ProtocolDecoder {
        private final Logger m_decoderLog = LoggerFactory.getLogger(this.getClass());
        private volatile DemuxableProtocolDecoder m_currentDecoder;
        private final List<DemuxableProtocolCodecFactory> m_codecFactories = new LinkedList<DemuxableProtocolCodecFactory>();

        private DemuxingProtocolDecoder(List<DemuxableProtocolCodecFactory> factories) {
            this.m_codecFactories.addAll(factories);
        }

        public void decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
            while (in.hasRemaining()) {
                if (this.m_currentDecoder == null || this.m_currentDecoder.atMessageBoundary()) {
                    if (!this.enoughData(in)) break;
                    this.m_currentDecoder = this.selectDecoder(in);
                }
                this.m_currentDecoder.decode(session, in, out);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DemuxableProtocolDecoder selectDecoder(ByteBuffer in) {
            int limit = in.limit();
            int pos = in.position();
            try {
                for (DemuxableProtocolCodecFactory decoderFactory : this.m_codecFactories) {
                    if (!decoderFactory.canDecode(in)) continue;
                    this.m_decoderLog.debug("Returning decoder from factory: {}", (Object)decoderFactory);
                    DemuxableProtocolDecoder demuxableProtocolDecoder = decoderFactory.newDecoder();
                    return demuxableProtocolDecoder;
                }
            }
            finally {
                in.position(pos);
                in.limit(limit);
            }
            this.m_decoderLog.warn("Did not understand buffer: {}", (Object)MinaUtils.toAsciiString(in));
            throw new IllegalArgumentException("Could not read data: " + MinaUtils.toAsciiString(in));
        }

        private boolean enoughData(ByteBuffer in) {
            for (DemuxableProtocolCodecFactory decoderFactory : this.m_codecFactories) {
                if (decoderFactory.enoughData(in)) continue;
                return false;
            }
            return true;
        }

        public void dispose(IoSession session) throws Exception {
        }

        public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
        }
    }

    private static final class DemuxingProtocolEncoder
    implements ProtocolEncoder {
        private final Logger m_encoderLogger = LoggerFactory.getLogger(this.getClass());
        private final Collection<DemuxableProtocolCodecFactory> m_encoderFactories = new LinkedList<DemuxableProtocolCodecFactory>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DemuxingProtocolEncoder(List<DemuxableProtocolCodecFactory> factories) {
            List<DemuxableProtocolCodecFactory> list = factories;
            synchronized (list) {
                this.m_encoderFactories.addAll(factories);
            }
        }

        public void dispose(IoSession session) throws Exception {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
            this.m_encoderLogger.debug("Encoding message...");
            Class<?> messageClass = message.getClass();
            Collection<DemuxableProtocolCodecFactory> collection = this.m_encoderFactories;
            synchronized (collection) {
                for (DemuxableProtocolCodecFactory factory : this.m_encoderFactories) {
                    Class factoryClass = factory.getClassToEncode();
                    if (!factoryClass.isAssignableFrom(messageClass)) continue;
                    ProtocolEncoder encoder = factory.newEncoder();
                    encoder.encode(session, message, out);
                    return;
                }
            }
            this.m_encoderLogger.warn("Could not encode message: {}", message);
            this.m_encoderLogger.warn("Factories: {}", this.m_encoderFactories);
        }
    }
}

