/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util.mina;

import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.filter.codec.ProtocolDecoderOutput;
import org.littleshoot.util.mina.DecodingState;
import org.littleshoot.util.mina.DecodingStateMachine;
import org.littleshoot.util.mina.DemuxableProtocolDecoder;
import org.littleshoot.util.mina.StateMachineProtocolDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DemuxingStateMachineProtocolDecoder
implements DemuxableProtocolDecoder {
    private final Logger LOG = LoggerFactory.getLogger(StateMachineProtocolDecoder.class);
    private final DecodingStateMachine m_stateMachine;
    private DecodingState m_currentState;

    public DemuxingStateMachineProtocolDecoder(DecodingStateMachine stateMachine) {
        if (stateMachine == null) {
            throw new NullPointerException("null state machine");
        }
        this.m_stateMachine = stateMachine;
    }

    public void decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        block10: {
            DecodingState state = this.m_currentState;
            if (state == null) {
                state = this.m_stateMachine.init();
            }
            try {
                DecodingState oldState;
                int remaining;
                do {
                    if ((remaining = in.remaining()) == 0) {
                        this.LOG.debug("Breaking -- no remaining bytes...");
                    } else {
                        oldState = state;
                        if (this.LOG.isDebugEnabled()) {
                            this.LOG.debug("Calling decode on state: {}", (Object)state.getClass().getSimpleName());
                        }
                        if ((state = state.decode(in, out)) != null) continue;
                        this.LOG.debug("Got null state...breaking...");
                    }
                    break block10;
                } while (in.remaining() != remaining || oldState != state);
                this.LOG.debug("Nothing consumed...breaking");
            }
            catch (Exception e) {
                state = null;
                throw e;
            }
            finally {
                this.m_currentState = state;
            }
        }
    }

    public void dispose(IoSession session) throws Exception {
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
        this.LOG.debug("Finish decode called in top-level state machine protocol decoder");
    }

    @Override
    public boolean atMessageBoundary() {
        return this.m_currentState == null;
    }
}

