/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util.mina;

import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.filter.codec.ProtocolDecoderOutput;
import org.littleshoot.util.mina.DecodingState;

public abstract class FixedLengthDecodingState
implements DecodingState {
    protected final int m_length;
    private ByteBuffer m_buffer;

    public FixedLengthDecodingState(int length) {
        this.m_length = length;
    }

    @Override
    public DecodingState decode(ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        if (this.m_buffer == null) {
            if (in.remaining() >= this.m_length) {
                int limit = in.limit();
                in.limit(in.position() + this.m_length);
                ByteBuffer product = in.slice();
                in.position(in.position() + this.m_length);
                in.limit(limit);
                return this.finishDecode(product, out);
            }
            this.m_buffer = ByteBuffer.allocate((int)this.m_length);
            this.m_buffer.put(in);
            return this;
        }
        if (in.remaining() >= this.m_length - this.m_buffer.position()) {
            int limit = in.limit();
            in.limit(in.position() + this.m_length - this.m_buffer.position());
            this.m_buffer.put(in);
            in.limit(limit);
            ByteBuffer product = this.m_buffer;
            this.m_buffer = null;
            return this.finishDecode(product.flip(), out);
        }
        this.m_buffer.put(in);
        return this;
    }

    protected abstract DecodingState finishDecode(ByteBuffer var1, ProtocolDecoderOutput var2) throws Exception;
}

